/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunConfigurationJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunTestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ScheduleRunRequestMarshaller
implements Marshaller<Request<ScheduleRunRequest>, ScheduleRunRequest> {
    public Request<ScheduleRunRequest> marshall(ScheduleRunRequest scheduleRunRequest) {
        if (scheduleRunRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)scheduleRunRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.ScheduleRun");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (scheduleRunRequest.getProjectArn() != null) {
                jsonWriter.key("projectArn").value((Object)scheduleRunRequest.getProjectArn());
            }
            if (scheduleRunRequest.getAppArn() != null) {
                jsonWriter.key("appArn").value((Object)scheduleRunRequest.getAppArn());
            }
            if (scheduleRunRequest.getDevicePoolArn() != null) {
                jsonWriter.key("devicePoolArn").value((Object)scheduleRunRequest.getDevicePoolArn());
            }
            if (scheduleRunRequest.getName() != null) {
                jsonWriter.key("name").value((Object)scheduleRunRequest.getName());
            }
            if (scheduleRunRequest.getTest() != null) {
                jsonWriter.key("test");
                ScheduleRunTestJsonMarshaller.getInstance().marshall(scheduleRunRequest.getTest(), jsonWriter);
            }
            if (scheduleRunRequest.getConfiguration() != null) {
                jsonWriter.key("configuration");
                ScheduleRunConfigurationJsonMarshaller.getInstance().marshall(scheduleRunRequest.getConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

