/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class SingleColumnMapper<T>
implements ResultSetMapper<T> {
    private final ResultSetMapper<T> delegate;

    public SingleColumnMapper(ResultColumnMapper<T> columnMapper) {
        this(columnMapper, 1);
    }

    public SingleColumnMapper(ResultColumnMapper<T> columnMapper, int columnNumber) {
        this.delegate = new ByNumber<T>(columnMapper, columnNumber);
    }

    public SingleColumnMapper(ResultColumnMapper<T> columnMapper, String columnLabel) {
        this.delegate = new ByLabel<T>(columnMapper, columnLabel);
    }

    @Override
    public T map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        return this.delegate.map(index, r, ctx);
    }

    private static class ByNumber<T>
    implements ResultSetMapper<T> {
        private final ResultColumnMapper<T> mapper;
        private final int number;

        public ByNumber(ResultColumnMapper<T> mapper, int number) {
            this.mapper = mapper;
            this.number = number;
        }

        @Override
        public T map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return this.mapper.mapColumn(r, this.number, ctx);
        }
    }

    private static class ByLabel<T>
    implements ResultSetMapper<T> {
        private final ResultColumnMapper<T> mapper;
        private final String label;

        public ByLabel(ResultColumnMapper<T> mapper, String label) {
            this.mapper = mapper;
            this.label = label;
        }

        @Override
        public T map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return this.mapper.mapColumn(r, this.label, ctx);
        }
    }
}

