/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedType;
import org.skife.jdbi.com.fasterxml.classmate.TypeBindings;
import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultBearing;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.customizers.SingleValueResult;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

abstract class ResultReturnThing {
    ResultReturnThing() {
    }

    public Object map(ResolvedMethod method, Query q, HandleDing h) {
        if (((Method)method.getRawMember()).isAnnotationPresent(Mapper.class)) {
            ResultSetMapper<?> mapper;
            try {
                mapper = ((Method)method.getRawMember()).getAnnotation(Mapper.class).value().newInstance();
            }
            catch (Exception e) {
                throw new UnableToCreateStatementException("unable to access mapper", e);
            }
            return this.result(q.map(mapper), h);
        }
        return this.result(q.mapTo(this.mapTo(method)), h);
    }

    static ResultReturnThing forType(ResolvedMethod method) {
        ResolvedType return_type = method.getReturnType();
        if (return_type == null) {
            throw new IllegalStateException(String.format("Method %s#%s is annotated as if it should return a value, but the method is void.", method.getDeclaringType().getErasedType().getName(), method.getName()));
        }
        if (return_type.isInstanceOf(ResultBearing.class)) {
            return new ResultBearingResultReturnThing(method);
        }
        if (return_type.isInstanceOf(Iterable.class)) {
            return new IterableReturningThing(method);
        }
        if (return_type.isInstanceOf(Iterator.class)) {
            return new IteratorResultReturnThing(method);
        }
        return new SingleValueResultReturnThing(method);
    }

    protected abstract Object result(ResultBearing var1, HandleDing var2);

    protected abstract Class<?> mapTo(ResolvedMethod var1);

    static class IterableReturningThing
    extends ResultReturnThing {
        private final ResolvedType resolvedType;
        private final Class<?> erased_type;

        public IterableReturningThing(ResolvedMethod method) {
            ResolvedType query_type = method.getReturnType();
            List<ResolvedType> query_return_types = query_type.typeParametersFor(Iterable.class);
            this.resolvedType = query_return_types.get(0);
            this.erased_type = method.getReturnType().getErasedType();
        }

        @Override
        protected Object result(ResultBearing q, HandleDing baton) {
            return q.list(this.erased_type);
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.resolvedType.getErasedType();
        }
    }

    static class IteratorResultReturnThing
    extends ResultReturnThing {
        private final ResolvedType resolvedType;

        public IteratorResultReturnThing(ResolvedMethod method) {
            ResolvedType query_type = method.getReturnType();
            List<ResolvedType> query_return_types = query_type.typeParametersFor(Iterator.class);
            this.resolvedType = query_return_types.get(0);
        }

        @Override
        protected Object result(ResultBearing q, final HandleDing baton) {
            boolean isEmpty;
            final ResultIterator itty = q.iterator();
            boolean bl = isEmpty = !itty.hasNext();
            if (isEmpty) {
                itty.close();
            } else {
                baton.retain("iterator");
            }
            return new ResultIterator(){
                private boolean closed;
                private boolean hasNext;
                {
                    this.closed = isEmpty;
                    this.hasNext = !isEmpty;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    if (!this.closed) {
                        this.closed = true;
                        try {
                            itty.close();
                        }
                        finally {
                            baton.release("iterator");
                        }
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public Object next() {
                    Object rs;
                    try {
                        rs = itty.next();
                        this.hasNext = itty.hasNext();
                    }
                    catch (RuntimeException e) {
                        this.closeIgnoreException();
                        throw e;
                    }
                    if (!this.hasNext) {
                        this.close();
                    }
                    return rs;
                }

                public void closeIgnoreException() {
                    try {
                        this.close();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }

                @Override
                public void remove() {
                    itty.remove();
                }
            };
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.resolvedType.getErasedType();
        }
    }

    static class ResultBearingResultReturnThing
    extends ResultReturnThing {
        private final ResolvedType resolvedType;

        public ResultBearingResultReturnThing(ResolvedMethod method) {
            ResolvedType query_type = method.getReturnType();
            List<ResolvedType> query_return_types = query_type.typeParametersFor(Query.class);
            this.resolvedType = query_return_types.get(0);
        }

        @Override
        protected Object result(ResultBearing q, HandleDing baton) {
            return q;
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.resolvedType.getErasedType();
        }
    }

    static class SingleValueResultReturnThing
    extends ResultReturnThing {
        private final Class<?> returnType;
        private final Class<?> containerType;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SingleValueResultReturnThing(ResolvedMethod method) {
            if (((Method)method.getRawMember()).isAnnotationPresent(SingleValueResult.class)) {
                SingleValueResult svr = ((Method)method.getRawMember()).getAnnotation(SingleValueResult.class);
                if (SingleValueResult.Default.class == svr.value()) {
                    TypeBindings typeBindings = method.getReturnType().getTypeBindings();
                    if (typeBindings.size() != 1) throw new IllegalArgumentException("Ambiguous generic information. SingleValueResult type could not be fetched.");
                    this.returnType = typeBindings.getBoundType(0).getErasedType();
                } else {
                    this.returnType = svr.value();
                }
                this.containerType = method.getReturnType().getErasedType();
                return;
            } else {
                this.returnType = method.getReturnType().getErasedType();
                this.containerType = null;
            }
        }

        @Override
        protected Object result(ResultBearing q, HandleDing baton) {
            return null == this.containerType ? q.first() : q.first(this.containerType);
        }

        @Override
        protected Class<?> mapTo(ResolvedMethod method) {
            return this.returnType;
        }
    }
}

