/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ReflectionBeanMapper<T>
implements ResultSetMapper<T> {
    private final Class<T> type;
    private final Map<String, Field> properties = new HashMap<String, Field>();

    public ReflectionBeanMapper(Class<T> type) {
        this.type = type;
        this.cacheAllFieldsIncludingSuperClass(type);
    }

    private void cacheAllFieldsIncludingSuperClass(Class<T> type) {
        for (Class<T> aClass = type; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                this.properties.put(field.getName().toLowerCase(), field);
            }
        }
    }

    @Override
    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String name = metadata.getColumnLabel(i).toLowerCase();
            Field field = this.properties.get(name);
            if (field == null) continue;
            Class<?> type = field.getType();
            ResultColumnMapper mapper = ctx.columnMapperFor(type);
            Object value = mapper != null ? mapper.mapColumn(rs, i, ctx) : rs.getObject(i);
            try {
                field.setAccessible(true);
                field.set(bean, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access property, %s", name), e);
            }
        }
        return bean;
    }
}

