/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.skife.jdbi.v2.InferredColumnMapperFactory;
import org.skife.jdbi.v2.InferredMapperFactory;
import org.skife.jdbi.v2.PrimitivesColumnMapperFactory;
import org.skife.jdbi.v2.ResultColumnMapperFactory;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.SingleColumnMapper;

class MappingRegistry {
    private static final PrimitivesColumnMapperFactory BUILT_INS = new PrimitivesColumnMapperFactory();
    private final List<ResultSetMapperFactory> rowFactories = new CopyOnWriteArrayList<ResultSetMapperFactory>();
    private final ConcurrentHashMap<Class, ResultSetMapper> rowCache = new ConcurrentHashMap();
    private final List<ResultColumnMapperFactory> columnFactories = new CopyOnWriteArrayList<ResultColumnMapperFactory>();
    private final ConcurrentHashMap<Class, ResultColumnMapper> columnCache = new ConcurrentHashMap();

    public MappingRegistry(MappingRegistry parent) {
        this.rowFactories.addAll(parent.rowFactories);
        this.rowCache.putAll(parent.rowCache);
        this.columnFactories.addAll(parent.columnFactories);
        this.columnCache.putAll(parent.columnCache);
    }

    public MappingRegistry() {
    }

    public void addMapper(ResultSetMapper mapper) {
        this.addMapper(new InferredMapperFactory(mapper));
    }

    public void addMapper(ResultSetMapperFactory factory) {
        this.rowFactories.add(factory);
        this.rowCache.clear();
    }

    public ResultSetMapper<?> mapperFor(Class<?> type, StatementContext ctx) {
        ResultSetMapper<Object> mapper = this.rowCache.get(type);
        if (mapper != null) {
            return mapper;
        }
        for (ResultSetMapperFactory factory : this.rowFactories) {
            if (!factory.accepts(type, ctx)) continue;
            mapper = factory.mapperFor(type, ctx);
            this.rowCache.put(type, mapper);
            return mapper;
        }
        ResultColumnMapper<?> columnMapper = this.columnMapperFor(type, ctx);
        if (columnMapper != null) {
            mapper = new SingleColumnMapper(columnMapper);
            this.rowCache.put(type, mapper);
            return mapper;
        }
        throw new DBIException("No mapper registered for " + type.getName()){};
    }

    public void addColumnMapper(ResultColumnMapper mapper) {
        this.addColumnMapper(new InferredColumnMapperFactory(mapper));
    }

    public void addColumnMapper(ResultColumnMapperFactory factory) {
        this.columnFactories.add(factory);
        this.columnCache.clear();
    }

    public ResultColumnMapper<?> columnMapperFor(Class<?> type, StatementContext ctx) {
        ResultColumnMapper mapper = this.columnCache.get(type);
        if (mapper != null) {
            return mapper;
        }
        for (ResultColumnMapperFactory factory : this.columnFactories) {
            if (!factory.accepts(type, ctx)) continue;
            mapper = factory.columnMapperFor(type, ctx);
            this.columnCache.put(type, mapper);
            return mapper;
        }
        if (BUILT_INS.accepts(type, ctx)) {
            mapper = BUILT_INS.columnMapperFor(type, ctx);
            this.columnCache.put(type, mapper);
            return mapper;
        }
        return null;
    }
}

