/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.skife.jdbi.org.antlr.runtime.ANTLRStringStream;
import org.skife.jdbi.org.antlr.runtime.Token;
import org.skife.jdbi.rewriter.hash.HashStatementLexer;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.RewrittenStatement;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class HashPrefixStatementRewriter
implements StatementRewriter {
    private final Map<String, ParsedStatement> cache = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public RewrittenStatement rewrite(String sql, Binding params, StatementContext ctx) {
        ParsedStatement stmt = this.cache.get(sql);
        if (stmt == null) {
            try {
                stmt = this.parseString(sql);
                this.cache.put(sql, stmt);
            }
            catch (IllegalArgumentException e) {
                throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", e, ctx);
            }
        }
        return new MyRewrittenStatement(stmt, ctx);
    }

    ParsedStatement parseString(String sql) throws IllegalArgumentException {
        ParsedStatement stmt = new ParsedStatement();
        StringBuilder b = new StringBuilder();
        HashStatementLexer lexer = new HashStatementLexer(new ANTLRStringStream(sql));
        Token t = lexer.nextToken();
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 8: {
                    b.append(t.getText());
                    break;
                }
                case 9: {
                    stmt.addNamedParamAt(t.getText().substring(1, t.getText().length()));
                    b.append("?");
                    break;
                }
                case 11: {
                    b.append(t.getText());
                    break;
                }
                case 5: {
                    b.append(t.getText());
                    break;
                }
                case 10: {
                    b.append("?");
                    stmt.addPositionalParamAt();
                    break;
                }
                case 6: {
                    b.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        stmt.sql = b.toString();
        return stmt;
    }

    static class ParsedStatement {
        private String sql;
        private boolean positionalOnly = true;
        private List<String> params = new ArrayList<String>();

        ParsedStatement() {
        }

        public void addNamedParamAt(String name) {
            this.positionalOnly = false;
            this.params.add(name);
        }

        public void addPositionalParamAt() {
            this.params.add("*");
        }

        public String getParsedSql() {
            return this.sql;
        }
    }

    private static class MyRewrittenStatement
    implements RewrittenStatement {
        private final ParsedStatement stmt;
        private final StatementContext context;

        public MyRewrittenStatement(ParsedStatement stmt, StatementContext ctx) {
            this.context = ctx;
            this.stmt = stmt;
        }

        @Override
        public void bind(Binding params, PreparedStatement statement) throws SQLException {
            if (this.stmt.positionalOnly) {
                boolean finished = false;
                int i = 0;
                while (!finished) {
                    Argument a = params.forPosition(i);
                    if (a != null) {
                        try {
                            a.apply(i + 1, statement, this.context);
                        }
                        catch (SQLException e) {
                            throw new UnableToExecuteStatementException(String.format("Exception while binding positional param at (0 based) position %d", i), e, this.context);
                        }
                    } else {
                        finished = true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                for (String named_param : this.stmt.params) {
                    if ("*".equals(named_param)) continue;
                    Argument a = params.forName(named_param);
                    if (a == null) {
                        a = params.forPosition(i);
                    }
                    if (a == null) {
                        String msg = String.format("Unable to execute, no named parameter matches \"%s\" and no positional param for place %d (which is %d in the JDBC 'start at 1' scheme) has been set.", named_param, i, i + 1);
                        throw new UnableToExecuteStatementException(msg, this.context);
                    }
                    try {
                        a.apply(i + 1, statement, this.context);
                    }
                    catch (SQLException e) {
                        throw new UnableToCreateStatementException(String.format("Exception while binding '%s'", named_param), e, this.context);
                    }
                    ++i;
                }
            }
        }

        @Override
        public String getSql() {
            return this.stmt.getParsedSql();
        }
    }
}

