/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.util;

import java.util.concurrent.atomic.AtomicLong;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001A4Q!\u0001\u0002\u0001\t)\u0011AcQ8oGV\u0014(/\u001a8u%&twMQ;gM\u0016\u0014(BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u000b\u0003\u0017\t\u001a\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011!\u0019\u0002A!A!\u0002\u0013)\u0012\u0001C2ba\u0006\u001c\u0017\u000e^=\u0004\u0001A\u0011QBF\u0005\u0003/9\u00111!\u00138u\u0011!I\u0002AaA!\u0002\u0017Q\u0012AC3wS\u0012,gnY3%cA\u00191D\b\u0011\u000e\u0003qQ!!\b\b\u0002\u000fI,g\r\\3di&\u0011q\u0004\b\u0002\t\u00072\f7o\u001d+bOB\u0011\u0011E\t\u0007\u0001\t\u0015\u0019\u0003A1\u0001%\u0005\u0005!\u0016CA\u0013)!\tia%\u0003\u0002(\u001d\t9aj\u001c;iS:<\u0007CA\u0007*\u0013\tQcBA\u0002B]fDQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtDC\u0001\u00183)\ty\u0013\u0007E\u00021\u0001\u0001j\u0011A\u0001\u0005\u00063-\u0002\u001dA\u0007\u0005\u0006'-\u0002\r!\u0006\u0005\u0007i\u0001\u0001\u000b\u0011B\u001b\u0002\u00119,\u0007\u0010\u001e*fC\u0012\u0004\"A\u000e \u000e\u0003]R!\u0001O\u001d\u0002\r\u0005$x.\\5d\u0015\tQ4(\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0001\u001f\u000b\u0003u\nAA[1wC&\u0011qh\u000e\u0002\u000b\u0003R|W.[2M_:<\u0007BB!\u0001A\u0003%Q'A\u0005oKb$xK]5uK\"11\t\u0001Q\u0001\nU\na\u0002];cY&\u001c\b.\u001a3Xe&$X\r\u0003\u0004F\u0001\u0001\u0006IAR\u0001\u0005e&tw\rE\u0002\u000e\u000f\u0002J!\u0001\u0013\b\u0003\u000b\u0005\u0013(/Y=\t\r)\u0003\u0001\u0015\"\u0003L\u0003\u001d\u0001XO\u00197jg\"$\"\u0001T(\u0011\u00055i\u0015B\u0001(\u000f\u0005\u0011)f.\u001b;\t\u000bAK\u0005\u0019A)\u0002\u000b]D\u0017n\u00195\u0011\u00055\u0011\u0016BA*\u000f\u0005\u0011auN\\4\t\u000bU\u0003AQ\u0001,\u0002\rQ\u0014\u0018pR3u)\u00059\u0006cA\u0007YA%\u0011\u0011L\u0004\u0002\u0007\u001fB$\u0018n\u001c8)\u0005Q[\u0006C\u0001/`\u001b\u0005i&B\u00010\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0003Av\u0013q\u0001^1jYJ,7\rC\u0003c\u0001\u0011\u00151-A\u0004uef\u0004V-Z6\u0016\u0003]CQ!\u001a\u0001\u0005\u0006\u0019\fa\u0001\u001e:z!V$HCA4k!\ti\u0001.\u0003\u0002j\u001d\t9!i\\8mK\u0006t\u0007\"B6e\u0001\u0004\u0001\u0013AA3mQ\t!7\fC\u0003o\u0001\u0011\u0015q.\u0001\u0003tSj,W#A\u000b")
public class ConcurrentRingBuffer<T> {
    private final int capacity;
    private final AtomicLong nextRead;
    private final AtomicLong nextWrite;
    private final AtomicLong publishedWrite;
    private final Object ring;

    private void publish(long which) {
        while (this.publishedWrite.get() != which - 1L) {
        }
        boolean ok = this.publishedWrite.compareAndSet(which - 1L, which);
        Predef$.MODULE$.assert(ok);
    }

    public final Option<T> tryGet() {
        Object el;
        long r;
        do {
            long w;
            if ((w = this.publishedWrite.get()) < (r = this.nextRead.get())) {
                return None$.MODULE$;
            }
            el = ScalaRunTime$.MODULE$.array_apply(this.ring, (int)(r % (long)this.capacity));
        } while (!this.nextRead.compareAndSet(r, r + 1L));
        return new Some(el);
    }

    public final Option<T> tryPeek() {
        long r;
        long w = this.publishedWrite.get();
        return w < (r = this.nextRead.get()) ? None$.MODULE$ : new Some(ScalaRunTime$.MODULE$.array_apply(this.ring, (int)(r % (long)this.capacity)));
    }

    public final boolean tryPut(T el) {
        long r;
        long w;
        while ((w = this.nextWrite.get()) - (r = this.nextRead.get()) < (long)this.capacity) {
            if (!this.nextWrite.compareAndSet(w, w + 1L)) continue;
            ScalaRunTime$.MODULE$.array_update(this.ring, (int)(w % (long)this.capacity), el);
            this.publish(w);
            return true;
        }
        return false;
    }

    public final int size() {
        return (int)(this.nextWrite.get() - this.nextRead.get());
    }

    public ConcurrentRingBuffer(int capacity, ClassTag<T> evidence$1) {
        this.capacity = capacity;
        Predef$.MODULE$.assert(capacity > 0);
        this.nextRead = new AtomicLong(0L);
        this.nextWrite = new AtomicLong(0L);
        this.publishedWrite = new AtomicLong(-1L);
        this.ring = evidence$1.newArray(capacity);
    }
}

