/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.util;

import com.twitter.finagle.util.BufReader;
import com.twitter.finagle.util.BufReader$;
import com.twitter.io.Buf;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\t-\u0011QBQ;g%\u0016\fG-\u001a:J[Bd'BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0003\"vMJ+\u0017\rZ3s\u0011!9\u0002A!A!\u0002\u0013A\u0012a\u00012vMB\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0003S>L!!\b\u000e\u0003\u0007\t+h\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"a\u0005\u0001\t\u000b]q\u0002\u0019\u0001\r\t\r\u0011\u0002\u0001\u0015!\u0003&\u0003\raWM\u001c\t\u0003\u001b\u0019J!a\n\b\u0003\u0007%sG\u000f\u0003\u0004*\u0001\u0001\u0006K!J\u0001\u0004a>\u001c\b\"B\u0016\u0001\t\u0003a\u0013!\u0003:f[\u0006Lg.\u001b8h+\u0005)\u0003B\u0002\u0018\u0001A\u0013%q&\u0001\bdQ\u0016\u001c7NU3nC&t\u0017N\\4\u0015\u0005A\u001a\u0004CA\u00072\u0013\t\u0011dB\u0001\u0003V]&$\b\"\u0002\u001b.\u0001\u0004)\u0013A\u00028fK\u0012,G\r\u0003\u00047\u0001\u0001&IaN\u0001\u000bEf$XMR5oI\u0016\u0014HC\u0001\u001d@!\tIDH\u0004\u0002\u001au%\u00111HG\u0001\u0004\u0005V4\u0017BA\u001f?\u0005%\u0001&o\\2fgN|'O\u0003\u0002<5!)\u0001)\u000ea\u0001\u0003\u00061A/\u0019:hKR\u0004\"!\u0004\"\n\u0005\rs!\u0001\u0002\"zi\u0016DQ!\u0012\u0001\u0005\u0002\u0019\u000baB]3nC&t\u0017N\\4V]RLG\u000e\u0006\u0002&\u000f\")\u0001\n\u0012a\u0001\u0003\u0006!!-\u001f;f\u0011\u0015Q\u0005\u0001\"\u0001L\u0003!\u0011X-\u00193CsR,G#A!\t\u000b5\u0003A\u0011\u0001(\u0002!I,\u0017\rZ+og&<g.\u001a3CsR,G#A(\u0011\u00055\u0001\u0016BA)\u000f\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0015\u0019\u0006\u0001\"\u0001O\u0003-\u0011X-\u00193TQ>\u0014HOQ#\t\u000bU\u0003A\u0011\u0001(\u0002\u0017I,\u0017\rZ*i_J$H*\u0012\u0005\u0006/\u0002!\t\u0001W\u0001\u0014e\u0016\fG-\u00168tS\u001etW\rZ*i_J$()\u0012\u000b\u0002K!)!\f\u0001C\u00011\u0006\u0019\"/Z1e+:\u001c\u0018n\u001a8fINCwN\u001d;M\u000b\")A\f\u0001C\u00011\u0006a!/Z1e\u001b\u0016$\u0017.^7C\u000b\")a\f\u0001C\u00011\u0006a!/Z1e\u001b\u0016$\u0017.^7M\u000b\")\u0001\r\u0001C\u00011\u0006!\"/Z1e+:\u001c\u0018n\u001a8fI6+G-[;n\u0005\u0016CQA\u0019\u0001\u0005\u0002a\u000bAC]3bIVs7/[4oK\u0012lU\rZ5v[2+\u0005\"\u00023\u0001\t\u0003A\u0016!\u0003:fC\u0012Le\u000e\u001e\"F\u0011\u00151\u0007\u0001\"\u0001Y\u0003%\u0011X-\u00193J]RdU\tC\u0003i\u0001\u0011\u0005\u0011.A\tsK\u0006$WK\\:jO:,G-\u00138u\u0005\u0016#\u0012A\u001b\t\u0003\u001b-L!\u0001\u001c\b\u0003\t1{gn\u001a\u0005\u0006]\u0002!\t![\u0001\u0012e\u0016\fG-\u00168tS\u001etW\rZ%oi2+\u0005\"\u00029\u0001\t\u0003I\u0017A\u0003:fC\u0012duN\\4C\u000b\")!\u000f\u0001C\u0001S\u0006Q!/Z1e\u0019>tw\rT#\t\u000bQ\u0004A\u0011A;\u0002\u0017I,\u0017\r\u001a$m_\u0006$()\u0012\u000b\u0002mB\u0011Qb^\u0005\u0003q:\u0011QA\u00127pCRDQA\u001f\u0001\u0005\u0002m\fAB]3bI\u0012{WO\u00197f\u0005\u0016#\u0012\u0001 \t\u0003\u001buL!A \b\u0003\r\u0011{WO\u00197f\u0011\u0019\t\t\u0001\u0001C\u0001k\u0006Y!/Z1e\r2|\u0017\r\u001e'F\u0011\u0019\t)\u0001\u0001C\u0001w\u0006a!/Z1e\t>,(\r\\3M\u000b\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011!\u0003:fC\u0012\u0014\u0015\u0010^3t)\rA\u0012Q\u0002\u0005\b\u0003\u001f\t9\u00011\u0001&\u0003\u0005q\u0007bBA\n\u0001\u0011\u0005\u0011QC\u0001\u0005g.L\u0007\u000fF\u00021\u0003/Aq!a\u0004\u0002\u0012\u0001\u0007Q\u0005C\u0004\u0002\u001c\u0001!\t!!\b\u0002\u000fI,\u0017\rZ!mYR\t\u0001\u0004")
public class BufReaderImpl
implements BufReader {
    private final Buf buf;
    private final int len;
    private int pos;

    @Override
    public int remaining() {
        return this.len - this.pos;
    }

    private void checkRemaining(int needed) {
        if (this.remaining() < needed) {
            throw new BufReader.UnderflowException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tried to read ", " byte(s) when remaining bytes was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)needed), BoxesRunTime.boxToInteger((int)this.remaining())})));
        }
    }

    private Buf.Processor byteFinder(byte target) {
        return new Buf.Processor(this, target){
            private final byte target$1;

            public boolean apply(byte by) {
                return by != this.target$1;
            }
            {
                this.target$1 = target$1;
            }
        };
    }

    @Override
    public int remainingUntil(byte by) {
        int index;
        return this.remaining() == 0 ? -1 : ((index = this.buf.process(this.pos, this.len, this.byteFinder(by))) == -1 ? -1 : index - this.pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte readByte() {
        void var1_1;
        this.checkRemaining(1);
        byte ret = this.buf.get(this.pos);
        ++this.pos;
        return (byte)var1_1;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShortBE() {
        this.checkRemaining(2);
        int ret = (this.buf.get(this.pos) & 0xFF) << 8 | this.buf.get(this.pos + 1) & 0xFF;
        this.pos += 2;
        return (short)ret;
    }

    @Override
    public short readShortLE() {
        this.checkRemaining(2);
        int ret = this.buf.get(this.pos) & 0xFF | (this.buf.get(this.pos + 1) & 0xFF) << 8;
        this.pos += 2;
        return (short)ret;
    }

    @Override
    public int readUnsignedShortBE() {
        return this.readShortBE() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public int readMediumBE() {
        int unsigned = this.readUnsignedMediumBE();
        return unsigned > BufReader$.MODULE$.SignedMediumMax() ? unsigned | 0xFF000000 : unsigned;
    }

    @Override
    public int readMediumLE() {
        int unsigned = this.readUnsignedMediumLE();
        return unsigned > BufReader$.MODULE$.SignedMediumMax() ? unsigned | 0xFF000000 : unsigned;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readUnsignedMediumBE() {
        void var1_1;
        this.checkRemaining(3);
        int ret = (this.buf.get(this.pos) & 0xFF) << 16 | (this.buf.get(this.pos + 1) & 0xFF) << 8 | this.buf.get(this.pos + 2) & 0xFF;
        this.pos += 3;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readUnsignedMediumLE() {
        void var1_1;
        this.checkRemaining(3);
        int ret = this.buf.get(this.pos) & 0xFF | (this.buf.get(this.pos + 1) & 0xFF) << 8 | (this.buf.get(this.pos + 2) & 0xFF) << 16;
        this.pos += 3;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readIntBE() {
        void var1_1;
        this.checkRemaining(4);
        int ret = (this.buf.get(this.pos) & 0xFF) << 24 | (this.buf.get(this.pos + 1) & 0xFF) << 16 | (this.buf.get(this.pos + 2) & 0xFF) << 8 | this.buf.get(this.pos + 3) & 0xFF;
        this.pos += 4;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readIntLE() {
        void var1_1;
        this.checkRemaining(4);
        int ret = this.buf.get(this.pos) & 0xFF | (this.buf.get(this.pos + 1) & 0xFF) << 8 | (this.buf.get(this.pos + 2) & 0xFF) << 16 | (this.buf.get(this.pos + 3) & 0xFF) << 24;
        this.pos += 4;
        return (int)var1_1;
    }

    @Override
    public long readUnsignedIntBE() {
        return (long)this.readIntBE() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLongBE() {
        void var1_1;
        this.checkRemaining(8);
        long ret = (long)(this.buf.get(this.pos) & 0xFF) << 56 | (long)(this.buf.get(this.pos + 1) & 0xFF) << 48 | (long)(this.buf.get(this.pos + 2) & 0xFF) << 40 | (long)(this.buf.get(this.pos + 3) & 0xFF) << 32 | (long)(this.buf.get(this.pos + 4) & 0xFF) << 24 | (long)(this.buf.get(this.pos + 5) & 0xFF) << 16 | (long)(this.buf.get(this.pos + 6) & 0xFF) << 8 | (long)(this.buf.get(this.pos + 7) & 0xFF);
        this.pos += 8;
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readLongLE() {
        void var1_1;
        this.checkRemaining(8);
        long ret = (long)(this.buf.get(this.pos) & 0xFF) | (long)(this.buf.get(this.pos + 1) & 0xFF) << 8 | (long)(this.buf.get(this.pos + 2) & 0xFF) << 16 | (long)(this.buf.get(this.pos + 3) & 0xFF) << 24 | (long)(this.buf.get(this.pos + 4) & 0xFF) << 32 | (long)(this.buf.get(this.pos + 5) & 0xFF) << 40 | (long)(this.buf.get(this.pos + 6) & 0xFF) << 48 | (long)(this.buf.get(this.pos + 7) & 0xFF) << 56;
        this.pos += 8;
        return (long)var1_1;
    }

    @Override
    public float readFloatBE() {
        return Float.intBitsToFloat(this.readIntBE());
    }

    @Override
    public double readDoubleBE() {
        return Double.longBitsToDouble(this.readLongBE());
    }

    @Override
    public float readFloatLE() {
        return Float.intBitsToFloat(this.readIntLE());
    }

    @Override
    public double readDoubleLE() {
        return Double.longBitsToDouble(this.readLongLE());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Buf readBytes(int n) {
        void var2_2;
        if (n < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'n' must be non-negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
        }
        Buf ret = this.buf.slice(this.pos, this.pos + n);
        this.pos += n;
        return var2_2;
    }

    @Override
    public void skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'n' must be non-negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
        }
        this.checkRemaining(n);
        this.pos += n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Buf readAll() {
        void var1_1;
        Buf ret = this.buf.slice(this.pos, this.len);
        this.pos = this.len;
        return var1_1;
    }

    public BufReaderImpl(Buf buf) {
        this.buf = buf;
        this.len = buf.length();
        this.pos = 0;
    }
}

