/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.tracing;

import com.twitter.finagle.Init$;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.context.LocalContext;
import com.twitter.finagle.context.MarshalledContext;
import com.twitter.finagle.tracing.Annotation;
import com.twitter.finagle.tracing.Flags;
import com.twitter.finagle.tracing.Flags$;
import com.twitter.finagle.tracing.Record;
import com.twitter.finagle.tracing.SpanId;
import com.twitter.finagle.tracing.SpanId$;
import com.twitter.finagle.tracing.Trace;
import com.twitter.finagle.tracing.Trace$TraceCtx$;
import com.twitter.finagle.tracing.TraceId;
import com.twitter.finagle.tracing.TraceId$;
import com.twitter.finagle.tracing.Tracer;
import com.twitter.finagle.tracing.debugTrace$;
import com.twitter.finagle.util.ByteArrays$;
import com.twitter.io.Buf;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Return;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Try;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class Trace$ {
    public static final Trace$ MODULE$;
    private final LocalContext.Key<Trace.TraceCtx> traceCtx;
    public final Some<Object> com$twitter$finagle$tracing$Trace$$someTrue;
    public final Some<Object> com$twitter$finagle$tracing$Trace$$someFalse;
    private final MarshalledContext.Key<TraceId> idCtx;
    private final Random rng;
    public final TraceId com$twitter$finagle$tracing$Trace$$defaultId;
    private volatile boolean tracingEnabled;
    private final Function0<Trace.TraceCtx> EmptyTraceCtxFn;
    private final Function0<TraceId> defaultIdFn;

    static {
        new Trace$();
    }

    public MarshalledContext.Key<TraceId> idCtx() {
        return this.idCtx;
    }

    private Trace.TraceCtx ctx() {
        return Contexts$.MODULE$.local().getOrElse(this.traceCtx, this.EmptyTraceCtxFn);
    }

    public boolean hasId() {
        return Contexts$.MODULE$.broadcast().contains(this.idCtx());
    }

    public TraceId id() {
        return Contexts$.MODULE$.broadcast().getOrElse(this.idCtx(), this.defaultIdFn);
    }

    public Option<TraceId> idOption() {
        return Contexts$.MODULE$.broadcast().get(this.idCtx());
    }

    public boolean isTerminal() {
        return this.ctx().terminal();
    }

    public List<Tracer> tracers() {
        return this.ctx().tracers();
    }

    public void enable() {
        this.tracingEnabled = true;
    }

    public void disable() {
        this.tracingEnabled = false;
    }

    public TraceId nextId() {
        Option<TraceId> option;
        block4: {
            TraceId traceId;
            block3: {
                SpanId spanId;
                block2: {
                    spanId = SpanId$.MODULE$.apply(this.rng.nextLong());
                    option = this.idOption();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    TraceId id = (TraceId)some.x();
                    traceId = new TraceId((Option<SpanId>)new Some((Object)id.traceId()), (Option<SpanId>)new Some((Object)id.spanId()), spanId, id.sampled(), id.flags());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                traceId = new TraceId((Option<SpanId>)None$.MODULE$, (Option<SpanId>)None$.MODULE$, spanId, (Option<Object>)None$.MODULE$, Flags$.MODULE$.apply());
            }
            return traceId;
        }
        throw new MatchError(option);
    }

    public <R> R letId(TraceId traceId, boolean terminal, Function0<R> f) {
        return (R)(this.isTerminal() ? f.apply() : (terminal ? Contexts$.MODULE$.local().let(this.traceCtx, this.ctx().withTerminal(terminal), new Serializable(traceId, f){
            public static final long serialVersionUID = 0L;
            private final TraceId traceId$1;
            private final Function0 f$1;

            public final R apply() {
                return Contexts$.MODULE$.broadcast().let(Trace$.MODULE$.idCtx(), this.traceId$1, this.f$1);
            }
            {
                this.traceId$1 = traceId$1;
                this.f$1 = f$1;
            }
        }) : Contexts$.MODULE$.broadcast().let(this.idCtx(), traceId, f)));
    }

    public <R> boolean letId$default$2() {
        return false;
    }

    public <R> R letIdOption(Option<TraceId> traceIdOpt, Function0<R> f) {
        Option<TraceId> option;
        block4: {
            Object object;
            block3: {
                block2: {
                    option = traceIdOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    TraceId traceId = (TraceId)some.x();
                    object = this.letId(traceId, this.letId$default$2(), f);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                object = f.apply();
            }
            return (R)object;
        }
        throw new MatchError(option);
    }

    public <R> R letTracer(Tracer tracer, Function0<R> f) {
        return Contexts$.MODULE$.local().let(this.traceCtx, this.ctx().withTracer(tracer), f);
    }

    public <R> R letTracerAndNextId(Tracer tracer, boolean terminal, Function0<R> f) {
        return this.letTracerAndId(tracer, this.nextId(), terminal, f);
    }

    public <R> boolean letTracerAndNextId$default$2() {
        return false;
    }

    public <R> R letTracerAndId(Tracer tracer, TraceId id, boolean terminal, Function0<R> f) {
        Option<Object> option;
        block6: {
            R r;
            block3: {
                TraceId traceId;
                Trace.TraceCtx newCtx;
                block5: {
                    block4: {
                        block2: {
                            if (!this.ctx().terminal()) break block2;
                            r = this.letTracer(tracer, f);
                            break block3;
                        }
                        newCtx = this.ctx().withTracer(tracer).withTerminal(terminal);
                        option = id.sampled();
                        if (!None$.MODULE$.equals(option)) break block4;
                        Option<Object> x$7 = tracer.sampleTrace(id);
                        Option<SpanId> x$8 = id.copy$default$1();
                        Option<SpanId> x$9 = id.copy$default$2();
                        SpanId x$10 = id.copy$default$3();
                        Flags x$11 = id.copy$default$5();
                        traceId = id.copy(x$8, x$9, x$10, x$7, x$11);
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    traceId = id;
                }
                TraceId newId = traceId;
                r = Contexts$.MODULE$.local().let(this.traceCtx, newCtx, new Serializable(f, newId){
                    public static final long serialVersionUID = 0L;
                    private final Function0 f$2;
                    private final TraceId newId$1;

                    public final R apply() {
                        return Contexts$.MODULE$.broadcast().let(Trace$.MODULE$.idCtx(), this.newId$1, this.f$2);
                    }
                    {
                        this.f$2 = f$2;
                        this.newId$1 = newId$1;
                    }
                });
            }
            return r;
        }
        throw new MatchError(option);
    }

    public <R> boolean letTracerAndId$default$3() {
        return false;
    }

    public <R> R letClear(Function0<R> f) {
        return Contexts$.MODULE$.local().letClear(this.traceCtx, new Serializable(f){
            public static final long serialVersionUID = 0L;
            private final Function0 f$3;

            public final R apply() {
                return Contexts$.MODULE$.broadcast().letClear(Trace$.MODULE$.idCtx(), this.f$3);
            }
            {
                this.f$3 = f$3;
            }
        });
    }

    public <T> T traceService(String service, String rpc, Option<InetSocketAddress> hostOpt, Function0<T> f) {
        return (T)this.letId(this.nextId(), this.letId$default$2(), (Function0)new Serializable(service, rpc, hostOpt, f){
            public static final long serialVersionUID = 0L;
            private final String service$1;
            private final String rpc$1;
            private final Option hostOpt$1;
            private final Function0 f$4;

            public final T apply() {
                Trace$.MODULE$.recordBinary("finagle.version", Init$.MODULE$.finagleVersion());
                Trace$.MODULE$.recordServiceName(this.service$1);
                Trace$.MODULE$.recordRpc(this.rpc$1);
                this.hostOpt$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(InetSocketAddress x$2) {
                        Trace$.MODULE$.recordServerAddr(x$2);
                    }
                });
                Trace$.MODULE$.record(new Annotation.ServerRecv());
                try {
                    return (T)this.f$4.apply();
                }
                finally {
                    Trace$.MODULE$.record(new Annotation.ServerSend());
                }
            }
            {
                this.service$1 = service$1;
                this.rpc$1 = rpc$1;
                this.hostOpt$1 = hostOpt$1;
                this.f$4 = f$4;
            }
        });
    }

    public <T> Option<InetSocketAddress> traceService$default$3() {
        return None$.MODULE$;
    }

    public boolean isActivelyTracing() {
        if (this.tracingEnabled) {
            List<Tracer> ts = this.tracers();
            if (ts.isEmpty()) {
                return false;
            }
            TraceId tid = this.id();
            return ts.exists((Function1)new Serializable(tid){
                public static final long serialVersionUID = 0L;
                private final TraceId tid$1;

                public final boolean apply(Tracer x$3) {
                    return x$3.isActivelyTracing(this.tid$1);
                }
                {
                    this.tid$1 = tid$1;
                }
            });
        }
        return false;
    }

    private void uncheckedRecord(Record rec) {
        ((List)this.tracers().distinct()).foreach((Function1)new Serializable(rec){
            public static final long serialVersionUID = 0L;
            private final Record rec$1;

            public final void apply(Tracer t) {
                t.record(this.rec$1);
            }
            {
                this.rec$1 = rec$1;
            }
        });
    }

    public void record(Function0<Record> rec) {
        if (BoxesRunTime.unboxToBoolean((Object)debugTrace$.MODULE$.apply())) {
            System.err.println(rec.apply());
        }
        if (this.isActivelyTracing()) {
            this.uncheckedRecord((Record)rec.apply());
        }
    }

    public <T> T time(String message, Function0<T> f) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        Object rv = f.apply();
        this.record(message, (Duration)elapsed.apply());
        return (T)rv;
    }

    public <T> Future<T> timeFuture(String message, Future<T> f) {
        Time start = Time$.MODULE$.now();
        f.ensure((Function0)new Serializable(message, start){
            public static final long serialVersionUID = 0L;
            private final String message$1;
            private final Time start$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Trace$.MODULE$.record(this.message$1, this.start$1.untilNow());
            }
            {
                this.message$1 = message$1;
                this.start$1 = start$1;
            }
        });
        return f;
    }

    public void record(Annotation ann) {
        if (BoxesRunTime.unboxToBoolean((Object)debugTrace$.MODULE$.apply())) {
            System.err.println(new Record(this.id(), Time$.MODULE$.now(), ann, (Option<Duration>)None$.MODULE$));
        }
        if (this.isActivelyTracing()) {
            this.uncheckedRecord(new Record(this.id(), Time$.MODULE$.now(), ann, (Option<Duration>)None$.MODULE$));
        }
    }

    public void record(Annotation ann, Duration duration) {
        if (BoxesRunTime.unboxToBoolean((Object)debugTrace$.MODULE$.apply())) {
            System.err.println(new Record(this.id(), Time$.MODULE$.now(), ann, (Option<Duration>)new Some((Object)duration)));
        }
        if (this.isActivelyTracing()) {
            this.uncheckedRecord(new Record(this.id(), Time$.MODULE$.now(), ann, (Option<Duration>)new Some((Object)duration)));
        }
    }

    public void record(String message) {
        this.record(new Annotation.Message(message));
    }

    public void record(String message, Duration duration) {
        this.record(new Annotation.Message(message), duration);
    }

    public void recordRpcname(String service, String rpc) {
        this.record(new Annotation.Rpcname(service, rpc));
    }

    public void recordServiceName(String serviceName) {
        this.record(new Annotation.ServiceName(serviceName));
    }

    public void recordRpc(String name) {
        this.record(new Annotation.Rpc(name));
    }

    public void recordClientAddr(InetSocketAddress ia) {
        this.record(new Annotation.ClientAddr(ia));
    }

    public void recordServerAddr(InetSocketAddress ia) {
        this.record(new Annotation.ServerAddr(ia));
    }

    public void recordLocalAddr(InetSocketAddress ia) {
        this.record(new Annotation.LocalAddr(ia));
    }

    public void recordBinary(String key, Object value) {
        this.record(new Annotation.BinaryAnnotation(key, value));
    }

    public void recordBinaries(Map<String, Object> annotations) {
        if (this.isActivelyTracing()) {
            annotations.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, Object> x$4) {
                    Tuple2<String, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        Object value = tuple2._2();
                        Trace$.MODULE$.recordBinary(key, value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
    }

    private Trace$() {
        MODULE$ = this;
        this.traceCtx = new LocalContext.Key(Contexts$.MODULE$.local());
        this.com$twitter$finagle$tracing$Trace$$someTrue = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.com$twitter$finagle$tracing$Trace$$someFalse = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.idCtx = new MarshalledContext.Key<TraceId>(){
            private final ThreadLocal<byte[]> local;

            private ThreadLocal<byte[]> local() {
                return this.local;
            }

            public Buf marshal(TraceId id) {
                return Buf.ByteArray$.Owned$.MODULE$.apply(TraceId$.MODULE$.serialize(id));
            }

            public Try<TraceId> tryUnmarshal(Buf body) {
                if (body.length() != 32) {
                    return new Throw((Throwable)new IllegalArgumentException("Expected 32 bytes"));
                }
                byte[] bytes = this.local().get();
                body.write(bytes, 0);
                long span64 = ByteArrays$.MODULE$.get64be(bytes, 0);
                long parent64 = ByteArrays$.MODULE$.get64be(bytes, 8);
                long trace64 = ByteArrays$.MODULE$.get64be(bytes, 16);
                long flags64 = ByteArrays$.MODULE$.get64be(bytes, 24);
                Flags flags = new Flags(flags64);
                Some<Object> sampled = flags.isFlagSet(Flags$.MODULE$.SamplingKnown()) ? (flags.isFlagSet(Flags$.MODULE$.Sampled()) ? Trace$.MODULE$.com$twitter$finagle$tracing$Trace$$someTrue : Trace$.MODULE$.com$twitter$finagle$tracing$Trace$$someFalse) : None$.MODULE$;
                TraceId traceId = new TraceId((Option<SpanId>)(trace64 == parent64 ? None$.MODULE$ : new Some((Object)SpanId$.MODULE$.apply(trace64))), (Option<SpanId>)(parent64 == span64 ? None$.MODULE$ : new Some((Object)SpanId$.MODULE$.apply(parent64))), SpanId$.MODULE$.apply(span64), (Option<Object>)sampled, flags);
                return new Return((Object)traceId);
            }
            {
                this.local = new ThreadLocal<byte[]>(this){

                    public byte[] initialValue() {
                        return new byte[32];
                    }
                };
            }
        };
        this.rng = new Random();
        this.com$twitter$finagle$tracing$Trace$$defaultId = new TraceId((Option<SpanId>)None$.MODULE$, (Option<SpanId>)None$.MODULE$, SpanId$.MODULE$.apply(this.rng.nextLong()), (Option<Object>)None$.MODULE$, Flags$.MODULE$.apply());
        this.tracingEnabled = true;
        this.EmptyTraceCtxFn = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trace.TraceCtx apply() {
                return Trace$TraceCtx$.MODULE$.empty();
            }
        };
        this.defaultIdFn = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TraceId apply() {
                return Trace$.MODULE$.com$twitter$finagle$tracing$Trace$$defaultId;
            }
        };
    }
}

