/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.ssl.server;

import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.ApplicationProtocols$Unspecified$;
import com.twitter.finagle.ssl.CipherSuites;
import com.twitter.finagle.ssl.CipherSuites$Unspecified$;
import com.twitter.finagle.ssl.Engine;
import com.twitter.finagle.ssl.KeyCredentials;
import com.twitter.finagle.ssl.KeyCredentials$Unspecified$;
import com.twitter.finagle.ssl.Ssl$;
import com.twitter.finagle.ssl.SslConfigurationException$;
import com.twitter.finagle.ssl.SslConfigurations$;
import com.twitter.finagle.ssl.server.SslServerConfiguration;
import com.twitter.finagle.ssl.server.SslServerEngineFactory;
import java.io.File;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;

public final class LegacyServerEngineFactory$
extends SslServerEngineFactory {
    public static final LegacyServerEngineFactory$ MODULE$;

    static {
        new LegacyServerEngineFactory$();
    }

    private Option<String> cipherSuitesToString(CipherSuites cipherSuites) {
        CipherSuites cipherSuites2;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    cipherSuites2 = cipherSuites;
                    if (!CipherSuites$Unspecified$.MODULE$.equals(cipherSuites2)) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!(cipherSuites2 instanceof CipherSuites.Enabled)) break block4;
                CipherSuites.Enabled enabled = (CipherSuites.Enabled)cipherSuites2;
                Seq<String> ciphers = enabled.ciphers();
                none$ = ciphers.isEmpty() ? None$.MODULE$ : new Some((Object)ciphers.mkString(":"));
            }
            return none$;
        }
        throw new MatchError((Object)cipherSuites2);
    }

    private Option<String> applicationProtocolsToString(ApplicationProtocols applicationProtocols) {
        ApplicationProtocols applicationProtocols2;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    applicationProtocols2 = applicationProtocols;
                    if (!ApplicationProtocols$Unspecified$.MODULE$.equals(applicationProtocols2)) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!(applicationProtocols2 instanceof ApplicationProtocols.Supported)) break block4;
                ApplicationProtocols.Supported supported = (ApplicationProtocols.Supported)applicationProtocols2;
                Seq<String> appProtos = supported.appProtocols();
                none$ = appProtos.isEmpty() ? None$.MODULE$ : new Some((Object)appProtos.mkString(","));
            }
            return none$;
        }
        throw new MatchError((Object)applicationProtocols2);
    }

    @Override
    public Engine apply(SslServerConfiguration config) {
        KeyCredentials keyCredentials;
        block6: {
            Engine engine;
            block5: {
                Option<String> appProtos;
                Option<String> cipherSuites;
                block4: {
                    SslConfigurations$.MODULE$.checkTrustCredentialsNotSupported("LegacyServerEngineFactory", config.trustCredentials());
                    SslConfigurations$.MODULE$.checkProtocolsNotSupported("LegacyServerEngineFactory", config.protocols());
                    SslConfigurations$.MODULE$.checkClientAuthNotSupported("LegacyServerEngineFactory", config.clientAuth());
                    cipherSuites = this.cipherSuitesToString(config.cipherSuites());
                    appProtos = this.applicationProtocolsToString(config.applicationProtocols());
                    keyCredentials = config.keyCredentials();
                    if (KeyCredentials$Unspecified$.MODULE$.equals(keyCredentials)) {
                        throw SslConfigurationException$.MODULE$.notSupported("KeyCredentials.Unspecified", "LegacyServerEngineFactory");
                    }
                    if (!(keyCredentials instanceof KeyCredentials.CertAndKey)) break block4;
                    KeyCredentials.CertAndKey certAndKey = (KeyCredentials.CertAndKey)keyCredentials;
                    File certFile = certAndKey.certificateFile();
                    File keyFile = certAndKey.keyFile();
                    engine = Ssl$.MODULE$.server(certFile.getAbsolutePath(), keyFile.getAbsolutePath(), null, (String)cipherSuites.orNull(Predef$.MODULE$.$conforms()), (String)appProtos.orNull(Predef$.MODULE$.$conforms()));
                    break block5;
                }
                if (!(keyCredentials instanceof KeyCredentials.CertKeyAndChain)) break block6;
                KeyCredentials.CertKeyAndChain certKeyAndChain = (KeyCredentials.CertKeyAndChain)keyCredentials;
                File certFile = certKeyAndChain.certificateFile();
                File keyFile = certKeyAndChain.keyFile();
                File chainFile = certKeyAndChain.caCertificateFile();
                engine = Ssl$.MODULE$.server(certFile.getAbsolutePath(), keyFile.getAbsolutePath(), chainFile.getAbsolutePath(), (String)cipherSuites.orNull(Predef$.MODULE$.$conforms()), (String)appProtos.orNull(Predef$.MODULE$.$conforms()));
            }
            Engine engine2 = engine;
            engine2.self().setUseClientMode(false);
            return engine2;
        }
        throw new MatchError((Object)keyCredentials);
    }

    private LegacyServerEngineFactory$() {
        MODULE$ = this;
    }
}

