/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.ssl;

import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.ApplicationProtocols$Unspecified$;
import com.twitter.finagle.ssl.CipherSuites;
import com.twitter.finagle.ssl.CipherSuites$Unspecified$;
import com.twitter.finagle.ssl.ClientAuth;
import com.twitter.finagle.ssl.ClientAuth$Needed$;
import com.twitter.finagle.ssl.ClientAuth$Off$;
import com.twitter.finagle.ssl.ClientAuth$Unspecified$;
import com.twitter.finagle.ssl.ClientAuth$Wanted$;
import com.twitter.finagle.ssl.IgnorantTrustManager;
import com.twitter.finagle.ssl.KeyCredentials;
import com.twitter.finagle.ssl.KeyCredentials$Unspecified$;
import com.twitter.finagle.ssl.Protocols;
import com.twitter.finagle.ssl.Protocols$Unspecified$;
import com.twitter.finagle.ssl.SslConfigurationException;
import com.twitter.finagle.ssl.SslConfigurationException$;
import com.twitter.finagle.ssl.TrustCredentials;
import com.twitter.finagle.ssl.TrustCredentials$Insecure$;
import com.twitter.finagle.ssl.TrustCredentials$Unspecified$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import com.twitter.util.security.Pkcs8KeyManagerFactory;
import com.twitter.util.security.X509TrustManagerFactory;
import java.io.File;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class SslConfigurations$ {
    public static final SslConfigurations$ MODULE$;

    static {
        new SslConfigurations$();
    }

    public Option<KeyManager[]> getKeyManagers(KeyCredentials keyCredentials) {
        KeyCredentials keyCredentials2;
        block7: {
            Try try_;
            block8: {
                None$ none$;
                block6: {
                    File keyFile;
                    block5: {
                        keyCredentials2 = keyCredentials;
                        if (!KeyCredentials$Unspecified$.MODULE$.equals(keyCredentials2)) break block5;
                        none$ = None$.MODULE$;
                        break block6;
                    }
                    if (!(keyCredentials2 instanceof KeyCredentials.CertAndKey)) break block7;
                    KeyCredentials.CertAndKey certAndKey = (KeyCredentials.CertAndKey)keyCredentials2;
                    File certFile = certAndKey.certificateFile();
                    Pkcs8KeyManagerFactory factory = new Pkcs8KeyManagerFactory(certFile, keyFile = certAndKey.keyFile());
                    Try tryKms = factory.getKeyManagers();
                    try_ = tryKms;
                    if (!(try_ instanceof Return)) break block8;
                    Return return_ = (Return)try_;
                    KeyManager[] kms = (KeyManager[])return_.r();
                    Some some = new Some((Object)kms);
                    none$ = some;
                }
                return none$;
            }
            if (try_ instanceof Throw) {
                Throw throw_ = (Throw)try_;
                Throwable ex = throw_.e();
                throw new SslConfigurationException(ex.getMessage(), ex);
            }
            throw new MatchError((Object)try_);
        }
        if (keyCredentials2 instanceof KeyCredentials.CertKeyAndChain) {
            throw SslConfigurationException$.MODULE$.notSupported("KeyCredentials.CertKeyAndChain", "SslConfigurations");
        }
        throw new MatchError((Object)keyCredentials2);
    }

    public Option<TrustManager[]> getTrustManagers(TrustCredentials trustCredentials) {
        TrustCredentials trustCredentials2;
        block7: {
            Try try_;
            block8: {
                None$ none$;
                block5: {
                    block6: {
                        block4: {
                            trustCredentials2 = trustCredentials;
                            if (!TrustCredentials$Unspecified$.MODULE$.equals(trustCredentials2)) break block4;
                            none$ = None$.MODULE$;
                            break block5;
                        }
                        if (!TrustCredentials$Insecure$.MODULE$.equals(trustCredentials2)) break block6;
                        none$ = new Some((Object)new TrustManager[]{new IgnorantTrustManager()});
                        break block5;
                    }
                    if (!(trustCredentials2 instanceof TrustCredentials.CertCollection)) break block7;
                    TrustCredentials.CertCollection certCollection = (TrustCredentials.CertCollection)trustCredentials2;
                    File file = certCollection.file();
                    X509TrustManagerFactory factory = new X509TrustManagerFactory(file);
                    Try tryTms = factory.getTrustManagers();
                    try_ = tryTms;
                    if (!(try_ instanceof Return)) break block8;
                    Return return_ = (Return)try_;
                    TrustManager[] tms = (TrustManager[])return_.r();
                    Some some = new Some((Object)tms);
                    none$ = some;
                }
                return none$;
            }
            if (try_ instanceof Throw) {
                Throw throw_ = (Throw)try_;
                Throwable ex = throw_.e();
                throw new SslConfigurationException(ex.getMessage(), ex);
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)trustCredentials2);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext initializeSslContext(KeyCredentials keyCredentials, TrustCredentials trustCredentials) {
        void var3_3;
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init((KeyManager[])this.getKeyManagers(keyCredentials).orNull(Predef$.MODULE$.$conforms()), (TrustManager[])this.getTrustManagers(trustCredentials).orNull(Predef$.MODULE$.$conforms()), null);
        return var3_3;
    }

    public void configureCipherSuites(SSLEngine sslEngine, CipherSuites cipherSuites) {
        CipherSuites cipherSuites2;
        block4: {
            block3: {
                block2: {
                    cipherSuites2 = cipherSuites;
                    if (!CipherSuites$Unspecified$.MODULE$.equals(cipherSuites2)) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(cipherSuites2 instanceof CipherSuites.Enabled)) break block4;
                CipherSuites.Enabled enabled = (CipherSuites.Enabled)cipherSuites2;
                Seq<String> ciphers = enabled.ciphers();
                sslEngine.setEnabledCipherSuites((String[])ciphers.toArray(ClassTag$.MODULE$.apply(String.class)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)cipherSuites2);
    }

    public void configureProtocols(SSLEngine sslEngine, Protocols protocols) {
        Protocols protocols2;
        block4: {
            block3: {
                block2: {
                    protocols2 = protocols;
                    if (!Protocols$Unspecified$.MODULE$.equals(protocols2)) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(protocols2 instanceof Protocols.Enabled)) break block4;
                Protocols.Enabled enabled = (Protocols.Enabled)protocols2;
                Seq<String> protocols3 = enabled.protocols();
                sslEngine.setEnabledProtocols((String[])protocols3.toArray(ClassTag$.MODULE$.apply(String.class)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)protocols2);
    }

    public void checkKeyCredentialsNotSupported(String engineFactoryName, KeyCredentials keyCredentials) {
        KeyCredentials keyCredentials2 = keyCredentials;
        if (KeyCredentials$Unspecified$.MODULE$.equals(keyCredentials2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (keyCredentials2 instanceof KeyCredentials.CertAndKey) {
            throw SslConfigurationException$.MODULE$.notSupported("KeyCredentials.CertAndKey", engineFactoryName);
        }
        if (keyCredentials2 instanceof KeyCredentials.CertKeyAndChain) {
            throw SslConfigurationException$.MODULE$.notSupported("KeyCredentials.CertKeyAndChain", engineFactoryName);
        }
        throw new MatchError((Object)keyCredentials2);
    }

    public void checkTrustCredentialsNotSupported(String engineFactoryName, TrustCredentials trustCredentials) {
        TrustCredentials trustCredentials2 = trustCredentials;
        if (TrustCredentials$Unspecified$.MODULE$.equals(trustCredentials2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (TrustCredentials$Insecure$.MODULE$.equals(trustCredentials2)) {
            throw SslConfigurationException$.MODULE$.notSupported("TrustCredentials.Insecure", engineFactoryName);
        }
        if (trustCredentials2 instanceof TrustCredentials.CertCollection) {
            throw SslConfigurationException$.MODULE$.notSupported("TrustCredentials.CertCollection", engineFactoryName);
        }
        throw new MatchError((Object)trustCredentials2);
    }

    public void checkProtocolsNotSupported(String engineFactoryName, Protocols protocols) {
        Protocols protocols2 = protocols;
        if (Protocols$Unspecified$.MODULE$.equals(protocols2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (protocols2 instanceof Protocols.Enabled) {
            throw SslConfigurationException$.MODULE$.notSupported("Protocols.Enabled", engineFactoryName);
        }
        throw new MatchError((Object)protocols2);
    }

    public void checkApplicationProtocolsNotSupported(String engineFactoryName, ApplicationProtocols applicationProtocols) {
        ApplicationProtocols applicationProtocols2 = applicationProtocols;
        if (ApplicationProtocols$Unspecified$.MODULE$.equals(applicationProtocols2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (applicationProtocols2 instanceof ApplicationProtocols.Supported) {
            throw SslConfigurationException$.MODULE$.notSupported("ApplicationProtocols.Supported", engineFactoryName);
        }
        throw new MatchError((Object)applicationProtocols2);
    }

    public void checkClientAuthNotSupported(String engineFactoryName, ClientAuth clientAuth) {
        ClientAuth clientAuth2 = clientAuth;
        if (ClientAuth$Unspecified$.MODULE$.equals(clientAuth2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (ClientAuth$Off$.MODULE$.equals(clientAuth2)) {
            throw SslConfigurationException$.MODULE$.notSupported("ClientAuth.Off", engineFactoryName);
        }
        if (ClientAuth$Wanted$.MODULE$.equals(clientAuth2)) {
            throw SslConfigurationException$.MODULE$.notSupported("ClientAuth.Wanted", engineFactoryName);
        }
        if (ClientAuth$Needed$.MODULE$.equals(clientAuth2)) {
            throw SslConfigurationException$.MODULE$.notSupported("ClientAuth.Needed", engineFactoryName);
        }
        throw new MatchError((Object)clientAuth2);
    }

    private SslConfigurations$() {
        MODULE$ = this;
    }
}

