/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.service.exp;

import com.twitter.conversions.time$;
import com.twitter.finagle.service.Backoff$;
import com.twitter.finagle.service.exp.FailureAccrualPolicy;
import com.twitter.util.Duration;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;

public final class FailureAccrualPolicy$ {
    public static final FailureAccrualPolicy$ MODULE$;
    public final int com$twitter$finagle$service$exp$FailureAccrualPolicy$$Success;
    public final int com$twitter$finagle$service$exp$FailureAccrualPolicy$$Failure;
    private final Stream<Duration> constantBackoff;

    static {
        new FailureAccrualPolicy$();
    }

    public Stream<Duration> constantBackoff() {
        return this.constantBackoff;
    }

    public FailureAccrualPolicy successRate(double requiredSuccessRate, int window, Stream<Duration> markDeadFor) {
        return new FailureAccrualPolicy.SuccessRateFailureAccrualPolicy(requiredSuccessRate, window, markDeadFor){
            private long totalRequests;

            public long emaStamp() {
                ++this.totalRequests;
                return this.totalRequests;
            }

            public void resetEmaCounter() {
                this.totalRequests = 0L;
            }
            {
                this.totalRequests = 0L;
            }
        };
    }

    public FailureAccrualPolicy successRateWithinDuration(double requiredSuccessRate, Duration window, Stream<Duration> markDeadFor) {
        Predef$.MODULE$.assert(window.isFinite(), (Function0)new Serializable(window){
            public static final long serialVersionUID = 0L;
            private final Duration window$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"window must be finite: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.window$1}));
            }
            {
                this.window$1 = window$1;
            }
        });
        return new FailureAccrualPolicy.SuccessRateFailureAccrualPolicy(requiredSuccessRate, window, markDeadFor){
            private Function0<Duration> timeElapsed;

            public long emaStamp() {
                return ((TimeLike)this.timeElapsed.apply()).inMilliseconds();
            }

            public void resetEmaCounter() {
                this.timeElapsed = Stopwatch$.MODULE$.start();
            }
            {
                this.timeElapsed = Stopwatch$.MODULE$.start();
            }
        };
    }

    public FailureAccrualPolicy consecutiveFailures(int numFailures, Stream<Duration> markDeadFor) {
        return new FailureAccrualPolicy(numFailures, markDeadFor){
            private final Stream<Duration> freshMarkDeadFor;
            private Stream<Duration> nextMarkDeadFor;
            private long consecutiveFailures;
            private final int numFailures$1;

            public synchronized void recordSuccess() {
                this.consecutiveFailures = 0L;
            }

            public synchronized Option<Duration> markDeadOnFailure() {
                None$ none$;
                ++this.consecutiveFailures;
                if (this.consecutiveFailures >= (long)this.numFailures$1) {
                    Duration duration = (Duration)this.nextMarkDeadFor.head();
                    this.nextMarkDeadFor = (Stream)this.nextMarkDeadFor.tail();
                    none$ = new Some((Object)duration);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            public synchronized void revived() {
                this.consecutiveFailures = 0L;
                this.nextMarkDeadFor = this.freshMarkDeadFor;
            }
            {
                this.numFailures$1 = numFailures$1;
                this.freshMarkDeadFor = (Stream)markDeadFor$2.$plus$plus(FailureAccrualPolicy$.MODULE$.constantBackoff(), Stream$.MODULE$.canBuildFrom());
                this.nextMarkDeadFor = this.freshMarkDeadFor;
                this.consecutiveFailures = 0L;
            }
        };
    }

    private FailureAccrualPolicy$() {
        MODULE$ = this;
        this.com$twitter$finagle$service$exp$FailureAccrualPolicy$$Success = 1;
        this.com$twitter$finagle$service$exp$FailureAccrualPolicy$$Failure = 0;
        this.constantBackoff = Backoff$.MODULE$.const(time$.MODULE$.intToTimeableNumber(300).seconds());
    }
}

