/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.service;

import com.twitter.finagle.ClientConnection;
import com.twitter.finagle.Filter;
import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.ServiceFactoryProxy;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.Status;
import com.twitter.finagle.Status$Closed$;
import com.twitter.finagle.Status$Open$;
import com.twitter.finagle.param.HighResTimer;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.service.RequeueFilter;
import com.twitter.finagle.service.Retries;
import com.twitter.finagle.service.Retries$;
import com.twitter.finagle.service.RetryBudget;
import com.twitter.finagle.service.RetryExceptionsFilter;
import com.twitter.finagle.service.RetryPolicy;
import com.twitter.finagle.service.RetryPolicy$;
import com.twitter.finagle.service.RetryPolicy$RetryableWriteException$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Timer;
import com.twitter.util.Try;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class Retries$ {
    public static final Retries$ MODULE$;
    private final Stack.Role Role;
    private final int Effort;
    private final double MaxRequeuesPerReq;

    static {
        new Retries$();
    }

    public Stack.Role Role() {
        return this.Role;
    }

    public int Effort() {
        return this.Effort;
    }

    public <Req, Rep> Stackable<ServiceFactory<Req, Rep>> moduleRequeueable() {
        return new Stack.Module3<Stats, Retries.Budget, HighResTimer, ServiceFactory<Req, Rep>>(){

            public Stack.Role role() {
                return Retries$.MODULE$.Role();
            }

            public String description() {
                return "Retries requests, at the service application level, that have been rejected";
            }

            public ServiceFactory<Req, Rep> make(Stats statsP, Retries.Budget budgetP, HighResTimer timerP, ServiceFactory<Req, Rep> next2) {
                StatsReceiver statsRecv = statsP.statsReceiver();
                StatsReceiver scoped = statsRecv.scope("retries");
                Counter requeues = scoped.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requeues"}));
                RetryBudget retryBudget = budgetP.retryBudget();
                Timer timer = timerP.timer();
                RequeueFilter<Req, Rep> filters = Retries$.MODULE$.com$twitter$finagle$service$Retries$$newRequeueFilter(retryBudget, budgetP.requeueBackoffs(), false, scoped, timer, next2);
                return Retries$.MODULE$.com$twitter$finagle$service$Retries$$svcFactory(retryBudget, filters, scoped, requeues, next2);
            }
        };
    }

    public <Req, Rep> Stackable<ServiceFactory<Req, Rep>> moduleWithRetryPolicy() {
        return new Stack.Module4<Stats, Retries.Budget, Retries.Policy, HighResTimer, ServiceFactory<Req, Rep>>(){

            public Stack.Role role() {
                return Retries$.MODULE$.Role();
            }

            public String description() {
                return "Retries requests, at the service application level, that have been rejected or meet the application-configured retry policy for transport level failures.";
            }

            public ServiceFactory<Req, Rep> make(Stats statsP, Retries.Budget budgetP, Retries.Policy policyP, HighResTimer timerP, ServiceFactory<Req, Rep> next2) {
                Filter filter2;
                StatsReceiver statsRecv = statsP.statsReceiver();
                StatsReceiver scoped = statsRecv.scope("retries");
                Counter requeues = scoped.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requeues"}));
                RetryBudget retryBudget = budgetP.retryBudget();
                RetryPolicy<Try<Nothing$>> retryPolicy = policyP.retryPolicy();
                if (retryPolicy == RetryPolicy$.MODULE$.Never()) {
                    filter2 = Retries$.MODULE$.com$twitter$finagle$service$Retries$$newRequeueFilter(retryBudget, budgetP.requeueBackoffs(), false, scoped, timerP.timer(), next2);
                } else {
                    RetryExceptionsFilter<Req, Rep> retryFilter = new RetryExceptionsFilter<Req, Rep>(retryPolicy, timerP.timer(), statsRecv, retryBudget);
                    RequeueFilter<Req, Rep> requeueFilter = Retries$.MODULE$.com$twitter$finagle$service$Retries$$newRequeueFilter(retryBudget, budgetP.requeueBackoffs(), true, scoped, timerP.timer(), next2);
                    filter2 = retryFilter.andThen(requeueFilter);
                }
                RequeueFilter<Req, Rep> filters = filter2;
                return Retries$.MODULE$.com$twitter$finagle$service$Retries$$svcFactory(retryBudget, filters, scoped, requeues, next2);
            }
        };
    }

    public <Req, Rep> RequeueFilter<Req, Rep> com$twitter$finagle$service$Retries$$newRequeueFilter(RetryBudget retryBudget, Stream<Duration> retrySchedule, boolean withdrawsOnly, StatsReceiver statsReceiver, Timer timer, ServiceFactory<Req, Rep> next2) {
        RetryBudget budget = withdrawsOnly ? new Retries.WithdrawOnlyRetryBudget(retryBudget) : retryBudget;
        return new RequeueFilter(budget, retrySchedule, statsReceiver, (Function0<Object>)new Serializable(next2){
            public static final long serialVersionUID = 0L;
            private final ServiceFactory next$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Status status2 = this.next$1.status();
                Status$Open$ status$Open$ = Status$Open$.MODULE$;
                return !(status2 != null ? !status2.equals(status$Open$) : status$Open$ != null);
            }
            {
                this.next$1 = next$1;
            }
        }, this.MaxRequeuesPerReq, timer);
    }

    public <Req, Rep> ServiceFactory<Req, Rep> com$twitter$finagle$service$Retries$$svcFactory(RetryBudget retryBudget, Filter<Req, Rep, Req, Rep> filters, StatsReceiver statsReceiver, Counter requeuesCounter, ServiceFactory<Req, Rep> next2) {
        return new ServiceFactoryProxy<Req, Rep>(retryBudget, filters, statsReceiver, requeuesCounter, next2){
            private final Gauge budgetGauge;
            public final Counter com$twitter$finagle$service$Retries$$anon$$notOpenCounter;
            private final Function1<Service<Req, Rep>, Service<Req, Rep>> serviceFn;
            public final RetryBudget retryBudget$1;
            public final Filter filters$1;
            public final Counter requeuesCounter$1;

            public Future<Service<Req, Rep>> com$twitter$finagle$service$Retries$$anon$$applySelf(ClientConnection conn, int n) {
                return ((ServiceFactory)this.self()).apply(conn).transform((Function1)new Serializable(this, conn, n){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final ClientConnection conn$1;
                    private final int n$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Future<Service<Req, Rep>> apply(Try<Service<Req, Rep>> x0$1) {
                        Throw throw_;
                        Throwable e;
                        Option<Throwable> option;
                        Try<Service<Req, Rep>> try_ = x0$1;
                        if (try_ instanceof Throw && !(option = RetryPolicy$RetryableWriteException$.MODULE$.unapply(e = (throw_ = (Throw)try_).e())).isEmpty() && this.n$1 > 0) {
                            Future<Service<Req, Rep>> future;
                            Status status2 = this.$outer.status();
                            Status$Open$ status$Open$ = Status$Open$.MODULE$;
                            if (!(status2 != null ? !status2.equals(status$Open$) : status$Open$ != null)) {
                                this.$outer.requeuesCounter$1.incr();
                                future = this.$outer.com$twitter$finagle$service$Retries$$anon$$applySelf(this.conn$1, this.n$1 - 1);
                                return future;
                            } else {
                                this.$outer.com$twitter$finagle$service$Retries$$anon$$notOpenCounter.incr();
                                future = Future$.MODULE$.exception(e);
                            }
                            return future;
                        }
                        if (!(try_ instanceof Return)) return Future$.MODULE$.const(try_);
                        Return return_ = (Return)try_;
                        Service deadSvc = (Service)return_.r();
                        Status status3 = deadSvc.status();
                        Status$Closed$ status$Closed$ = Status$Closed$.MODULE$;
                        if (status3 == null) {
                            if (status$Closed$ != null) {
                                return Future$.MODULE$.const(try_);
                            }
                        } else if (!status3.equals(status$Closed$)) return Future$.MODULE$.const(try_);
                        if (this.n$1 <= 0) return Future$.MODULE$.const(try_);
                        this.$outer.requeuesCounter$1.incr();
                        return this.$outer.com$twitter$finagle$service$Retries$$anon$$applySelf(this.conn$1, this.n$1 - 1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.conn$1 = conn$1;
                        this.n$1 = n$1;
                    }
                });
            }

            public Future<Service<Req, Rep>> apply(ClientConnection conn) {
                return this.com$twitter$finagle$service$Retries$$anon$$applySelf(conn, Retries$.MODULE$.Effort()).map(this.serviceFn);
            }

            public Future<BoxedUnit> close(Time deadline) {
                this.budgetGauge.remove();
                return this.self().close(deadline);
            }
            {
                this.retryBudget$1 = retryBudget$1;
                this.filters$1 = filters$1;
                this.requeuesCounter$1 = requeuesCounter$1;
                super(next$2);
                this.budgetGauge = statsReceiver$1.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"budget"}), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return this.$outer.retryBudget$1.balance();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.com$twitter$finagle$service$Retries$$anon$$notOpenCounter = statsReceiver$1.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not_open"}));
                this.serviceFn = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Service<Req, Rep> apply(Service<Req, Rep> service) {
                        return this.$outer.filters$1.andThen(service);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
        };
    }

    private Retries$() {
        MODULE$ = this;
        this.Role = new Stack.Role("Retries");
        this.Effort = 25;
        this.MaxRequeuesPerReq = 0.2;
    }
}

