/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.service;

import com.twitter.conversions.time$;
import com.twitter.finagle.Address;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.ServiceFactoryWrapper;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.client.Transporter$EndpointAddr$;
import com.twitter.finagle.package$;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.param.Logger$;
import com.twitter.finagle.param.ResponseClassifier$;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.param.Timer$;
import com.twitter.finagle.server.ServerInfo$;
import com.twitter.finagle.service.Backoff$;
import com.twitter.finagle.service.FailureAccrualFactory;
import com.twitter.finagle.service.FailureAccrualFactory$Param$;
import com.twitter.finagle.service.FailureAccrualFactory$Param$Disabled$;
import com.twitter.finagle.service.ReqRep;
import com.twitter.finagle.service.ResponseClass;
import com.twitter.finagle.service.exp.FailureAccrualPolicy;
import com.twitter.finagle.service.exp.FailureAccrualPolicy$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Level;
import com.twitter.util.Duration;
import com.twitter.util.Function0;
import com.twitter.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class FailureAccrualFactory$ {
    public static final FailureAccrualFactory$ MODULE$;
    private final Random rng;
    public final int com$twitter$finagle$service$FailureAccrualFactory$$DefaultConsecutiveFailures;
    public final double com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateThreshold;
    public final Duration com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateWindow;
    private final String UseSuccessRateDefaultPolicyId;
    private final Stream<Duration> jitteredBackoff;
    private final Stack.Role role;
    private final FailureAccrualFactory.Param Disabled;

    static {
        new FailureAccrualFactory$();
    }

    private boolean useSuccessRateDefaultPolicy() {
        return package$.MODULE$.CoreToggles().apply(this.UseSuccessRateDefaultPolicyId).apply$mcZI$sp(ServerInfo$.MODULE$.apply().id().hashCode());
    }

    public Stream<Duration> jitteredBackoff() {
        return this.jitteredBackoff;
    }

    public Function0<FailureAccrualPolicy> defaultPolicy() {
        return this.useSuccessRateDefaultPolicy() ? new Function0<FailureAccrualPolicy>(){

            public FailureAccrualPolicy apply() {
                return FailureAccrualPolicy$.MODULE$.successRateWithinDuration(FailureAccrualFactory$.MODULE$.com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateThreshold, FailureAccrualFactory$.MODULE$.com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateWindow, FailureAccrualFactory$.MODULE$.jitteredBackoff());
            }

            public String toString() {
                return new StringBuilder().append((Object)"FailureAccrualPolicy.successRateWithinDuration(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"successRate = ", ", window = ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)FailureAccrualFactory$.MODULE$.com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateThreshold), FailureAccrualFactory$.MODULE$.com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateWindow}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"markDeadFor = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FailureAccrualFactory$.MODULE$.jitteredBackoff()}))).toString();
            }
        } : new Function0<FailureAccrualPolicy>(){

            public FailureAccrualPolicy apply() {
                return FailureAccrualPolicy$.MODULE$.consecutiveFailures(FailureAccrualFactory$.MODULE$.com$twitter$finagle$service$FailureAccrualFactory$$DefaultConsecutiveFailures, FailureAccrualFactory$.MODULE$.jitteredBackoff());
            }

            public String toString() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FailureAccrualPolicy.consecutiveFailures(numFailures: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", markDeadFor: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)FailureAccrualFactory$.MODULE$.com$twitter$finagle$service$FailureAccrualFactory$$DefaultConsecutiveFailures), FailureAccrualFactory$.MODULE$.jitteredBackoff()}))).toString();
            }
        };
    }

    public scala.Function0<Duration> perturb(Duration markDeadFor, float perturbation, Random rand) {
        return new Serializable(markDeadFor, perturbation, rand){
            public static final long serialVersionUID = 0L;
            private final Duration markDeadFor$2;
            private final float perturbation$1;
            private final Random rand$1;

            public final Duration apply() {
                long ms = this.markDeadFor$2.inMilliseconds();
                return time$.MODULE$.intToTimeableNumber((int)((double)ms + (double)((float)((double)ms * (double)this.rand$1.nextFloat()) * this.perturbation$1))).milliseconds();
            }
            {
                this.markDeadFor$2 = markDeadFor$2;
                this.perturbation$1 = perturbation$1;
                this.rand$1 = rand$1;
            }
        };
    }

    public float perturb$default$2() {
        return 0.1f;
    }

    public Random perturb$default$3() {
        return this.rng;
    }

    public Stack.Role role() {
        return this.role;
    }

    private Function0<FailureAccrualPolicy> consecutiveFailurePolicy(int numFailures, scala.Function0<Duration> markDeadFor) {
        Stream<Duration> markDeadForStream = Backoff$.MODULE$.fromFunction(markDeadFor);
        return new Function0<FailureAccrualPolicy>(numFailures, markDeadForStream){
            private final int numFailures$1;
            private final Stream markDeadForStream$1;

            public FailureAccrualPolicy apply() {
                return FailureAccrualPolicy$.MODULE$.consecutiveFailures(this.numFailures$1, (Stream<Duration>)this.markDeadForStream$1);
            }

            public String toString() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FailureAccrualPolicy.consecutiveFailures("})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFailures: ", ", markDeadFor: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numFailures$1), this.markDeadForStream$1}))).toString();
            }
            {
                this.numFailures$1 = numFailures$1;
                this.markDeadForStream$1 = markDeadForStream$1;
            }
        };
    }

    public FailureAccrualFactory.Param Param(int numFailures, scala.Function0<Duration> markDeadFor) {
        return new FailureAccrualFactory.Param.Configured((scala.Function0<FailureAccrualPolicy>)this.consecutiveFailurePolicy(numFailures, markDeadFor));
    }

    public FailureAccrualFactory.Param Param(int numFailures, Duration markDeadFor) {
        return new FailureAccrualFactory.Param.Configured((scala.Function0<FailureAccrualPolicy>)this.consecutiveFailurePolicy(numFailures, (scala.Function0<Duration>)new Serializable(markDeadFor){
            public static final long serialVersionUID = 0L;
            private final Duration markDeadFor$1;

            public final Duration apply() {
                return this.markDeadFor$1;
            }
            {
                this.markDeadFor$1 = markDeadFor$1;
            }
        }));
    }

    public FailureAccrualFactory.Param Param(scala.Function0<FailureAccrualPolicy> failureAccrualPolicy) {
        return new FailureAccrualFactory.Param.Configured(failureAccrualPolicy);
    }

    public FailureAccrualFactory.Param Replaced(Function1<Timer, ServiceFactoryWrapper> factory) {
        return new FailureAccrualFactory.Param.Replaced(factory);
    }

    public FailureAccrualFactory.Param Replaced(ServiceFactoryWrapper factory) {
        return new FailureAccrualFactory.Param.Replaced((Function1<Timer, ServiceFactoryWrapper>)new Serializable(factory){
            public static final long serialVersionUID = 0L;
            private final ServiceFactoryWrapper factory$1;

            public final ServiceFactoryWrapper apply(Timer x$1) {
                return this.factory$1;
            }
            {
                this.factory$1 = factory$1;
            }
        });
    }

    public FailureAccrualFactory.Param Disabled() {
        return this.Disabled;
    }

    public <Req, Rep> Stackable<ServiceFactory<Req, Rep>> module() {
        return new Stack.ModuleParams<ServiceFactory<Req, Rep>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public Seq<Stack.Param<?>> parameters() {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stack.Param[]{(Stack.Param)Predef$.MODULE$.implicitly(Stats$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(FailureAccrualFactory$Param$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(Timer$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(Label$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(Logger$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(ResponseClassifier$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(Transporter$EndpointAddr$.MODULE$.param())}));
            }

            public ServiceFactory<Req, Rep> make(Stack.Params params, ServiceFactory<Req, Rep> next2) {
                FailureAccrualFactory.Param param;
                block5: {
                    FailureAccrualFactory<Req, Rep> failureAccrualFactory;
                    block3: {
                        block4: {
                            block2: {
                                param = params.apply(FailureAccrualFactory$Param$.MODULE$.param());
                                if (!(param instanceof FailureAccrualFactory.Param.Configured)) break block2;
                                FailureAccrualFactory.Param.Configured configured = (FailureAccrualFactory.Param.Configured)param;
                                scala.Function0<FailureAccrualPolicy> policy = configured.failureAccrualPolicy();
                                Timer timer = params.apply(Timer$.MODULE$.param()).timer();
                                StatsReceiver statsReceiver = params.apply(Stats$.MODULE$.param()).statsReceiver();
                                PartialFunction<ReqRep, ResponseClass> classifier = params.apply(ResponseClassifier$.MODULE$.param()).responseClassifier();
                                Logger logger = params.apply(Logger$.MODULE$.param()).log();
                                Address endpoint = params.apply(Transporter$EndpointAddr$.MODULE$.param()).addr();
                                String label = params.apply(Label$.MODULE$.param()).label();
                                failureAccrualFactory = new FailureAccrualFactory<Req, Rep>(this, next2, policy, timer, statsReceiver, classifier, logger, endpoint, label){
                                    private final Logger logger$1;
                                    private final Address endpoint$1;
                                    private final String label$1;

                                    public void didMarkDead() {
                                        this.logger$1.log((Level)Level.INFO$.MODULE$, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FailureAccrualFactory marking connection to \"", "\" as dead. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remote Address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.endpoint$1}))).toString());
                                        super.didMarkDead();
                                    }
                                    {
                                        this.logger$1 = logger$1;
                                        this.endpoint$1 = endpoint$1;
                                        this.label$1 = label$1;
                                        super(next$1, (FailureAccrualPolicy)policy$1.apply(), (PartialFunction<ReqRep, ResponseClass>)classifier$1, timer$1, statsReceiver$1.scope("failure_accrual"));
                                    }
                                };
                                break block3;
                            }
                            if (!(param instanceof FailureAccrualFactory.Param.Replaced)) break block4;
                            FailureAccrualFactory.Param.Replaced replaced = (FailureAccrualFactory.Param.Replaced)param;
                            Function1<Timer, ServiceFactoryWrapper> f = replaced.factory();
                            failureAccrualFactory = ((ServiceFactoryWrapper)f.apply((Object)params.apply(Timer$.MODULE$.param()).timer())).andThen(next2);
                            break block3;
                        }
                        if (!FailureAccrualFactory$Param$Disabled$.MODULE$.equals(param)) break block5;
                        failureAccrualFactory = next2;
                    }
                    return failureAccrualFactory;
                }
                throw new MatchError((Object)param);
            }
            {
                this.role = FailureAccrualFactory$.MODULE$.role();
                this.description = "Backoff from hosts that we cannot successfully make requests to";
            }
        };
    }

    private FailureAccrualFactory$() {
        MODULE$ = this;
        this.rng = new Random();
        this.com$twitter$finagle$service$FailureAccrualFactory$$DefaultConsecutiveFailures = 5;
        this.com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateThreshold = 0.8;
        this.com$twitter$finagle$service$FailureAccrualFactory$$DefaultSuccessRateWindow = time$.MODULE$.intToTimeableNumber(30).seconds();
        this.UseSuccessRateDefaultPolicyId = "com.twitter.finagle.core.UseSuccessRateFailureAccrual";
        this.jitteredBackoff = Backoff$.MODULE$.equalJittered(time$.MODULE$.intToTimeableNumber(5).seconds(), time$.MODULE$.intToTimeableNumber(300).seconds());
        this.role = new Stack.Role("FailureAccrual");
        this.Disabled = FailureAccrualFactory$Param$Disabled$.MODULE$;
    }
}

