/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty3.channel;

import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeLike;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u00015\u00111c\u00115b]:,Gn\u0015;biND\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000f\rD\u0017M\u001c8fY*\u0011QAB\u0001\u0007]\u0016$H/_\u001a\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010/5\t\u0001C\u0003\u0002\u0004#)\u0011!cE\u0001\u0006]\u0016$H/\u001f\u0006\u0003)U\tQA\u001b2pgNT\u0011AF\u0001\u0004_J<\u0017B\u0001\r\u0011\u0005Q\u0019\u0016.\u001c9mK\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\"A!\u0004\u0001B\u0001B\u0003%1$A\u0007ti\u0006$8OU3dK&4XM\u001d\t\u00039}i\u0011!\b\u0006\u0003=\u0019\tQa\u001d;biNL!\u0001I\u000f\u0003\u001bM#\u0018\r^:SK\u000e,\u0017N^3s\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u00065\u0005\u0002\ra\u0007\u0005\u0007Q\u0001\u0001\u000b\u0011B\u0015\u0002\u00071|w\r\u0005\u0002+c5\t1F\u0003\u0002-[\u00059An\\4hS:<'B\u0001\u00180\u0003\u0011)H/\u001b7\u000b\u0003A\nAA[1wC&\u0011!g\u000b\u0002\u0007\u0019><w-\u001a:\t\rQ\u0002\u0001\u0015!\u00036\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$\bC\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0019\tGo\\7jG*\u0011!(L\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001f8\u0005)\tEo\\7jG2{gn\u001a\u0005\u0007}\u0001\u0001\u000b\u0015B \u0002\u000f\u0015d\u0017\r]:fIB\u0019\u0001iQ#\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\u0019CU\"A$\u000b\u00059B\u0011BA%H\u0005!!UO]1uS>t\u0007BB&\u0001A\u0003%A*\u0001\u0005d_:tWm\u0019;t!\taR*\u0003\u0002O;\t91i\\;oi\u0016\u0014\bB\u0002)\u0001A\u0003%\u0011+\u0001\nd_:tWm\u0019;j_:$UO]1uS>t\u0007C\u0001\u000fS\u0013\t\u0019VD\u0001\u0003Ti\u0006$\bBB+\u0001A\u0003%\u0011+A\fd_:tWm\u0019;j_:\u0014VmY3jm\u0016$')\u001f;fg\"1q\u000b\u0001Q\u0001\nE\u000b1cY8o]\u0016\u001cG/[8o'\u0016tGOQ=uKNDa!\u0017\u0001!\u0002\u0013a\u0015!\u0004:fG\u0016Lg/\u001a3CsR,7\u000f\u0003\u0004\\\u0001\u0001\u0006I\u0001T\u0001\ng\u0016tGOQ=uKNDa!\u0018\u0001!\u0002\u0013a\u0015\u0001C<sSR\f'\r\\3\t\r}\u0003\u0001\u0015!\u0003M\u0003))hn\u001e:ji\u0006\u0014G.\u001a\u0005\u0007C\u0002\u0001\u000b\u0011B\u000e\u0002\u0015\u0015D8-\u001a9uS>t7\u000f\u0003\u0004d\u0001\u0001\u0006I\u0001T\u0001\fG2|7/Z:D_VtG\u000f\u0003\u0004f\u0001\u0001\u0006IAZ\u0001\fG>tg.Z2uS>t7\u000f\u0005\u0002\u001dO&\u0011\u0001.\b\u0002\u0006\u000f\u0006,x-\u001a\u0005\u0006U\u0002!\te[\u0001\fG\"\fgN\\3m\u001fB,g\u000eF\u0002m_R\u0004\"\u0001Q7\n\u00059\f%\u0001B+oSRDQ\u0001]5A\u0002E\f1a\u0019;y!\ty!/\u0003\u0002t!\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"B;j\u0001\u00041\u0018!A3\u0011\u0005=9\u0018B\u0001=\u0011\u0005E\u0019\u0005.\u00198oK2\u001cF/\u0019;f\u000bZ,g\u000e\u001e\u0005\u0006u\u0002!\te_\u0001\u000eoJLG/Z\"p[BdW\r^3\u0015\u00071dX\u0010C\u0003qs\u0002\u0007\u0011\u000fC\u0003vs\u0002\u0007a\u0010\u0005\u0002\u0010\u007f&\u0019\u0011\u0011\u0001\t\u0003)]\u0013\u0018\u000e^3D_6\u0004H.\u001a;j_:,e/\u001a8u\u0011\u001d\t)\u0001\u0001C!\u0003\u000f\tq\"\\3tg\u0006<WMU3dK&4X\r\u001a\u000b\u0006Y\u0006%\u00111\u0002\u0005\u0007a\u0006\r\u0001\u0019A9\t\u000fU\f\u0019\u00011\u0001\u0002\u000eA\u0019q\"a\u0004\n\u0007\u0005E\u0001C\u0001\u0007NKN\u001c\u0018mZ3Fm\u0016tG\u000fC\u0004\u0002\u0016\u0001!\t%a\u0006\u0002\u001d\rdwn]3SKF,Xm\u001d;fIR)A.!\u0007\u0002\u001c!1\u0001/a\u0005A\u0002EDa!^A\n\u0001\u00041\bbBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0001\u000eG\"\fgN\\3m\u00072|7/\u001a3\u0015\u000b1\f\u0019#!\n\t\rA\fi\u00021\u0001r\u0011\u0019)\u0018Q\u0004a\u0001m\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\u000b1\fi#a\f\t\rA\f9\u00031\u0001r\u0011!\t\t$a\nA\u0002\u0005M\u0012aA3wiB\u0019q\"!\u000e\n\u0007\u0005]\u0002C\u0001\bFq\u000e,\u0007\u000f^5p]\u00163XM\u001c;\t\u0011\u0005m\u0002\u0001)Q\u0005\u0003{\tq\u0002[1t\u0005\u0016,gn\u0016:ji\u0006\u0014G.\u001a\t\u0004\u0001\u0006}\u0012bAA!\u0003\n9!i\\8mK\u0006t\u0007\u0002CA#\u0001\u0001\u0006K!a\u0012\u0002\u000bMLgnY3\u0011\u0007\u0019\u000bI%C\u0002\u0002L\u001d\u0013A\u0001V5nK\"A\u0011q\n\u0001!\n\u0013\t\t&\u0001\bt_\u000e\\W\r\u001e#ve\u0006$\u0018n\u001c8\u0015\u0007\u0015\u000b\u0019\u0006\u0003\u0005\u0002V\u00055\u0003\u0019AA$\u0003\rqwn\u001e\u0005\b\u00033\u0002A\u0011IA.\u0003Y\u0019\u0007.\u00198oK2Le\u000e^3sKN$8\t[1oO\u0016$G#\u00027\u0002^\u0005}\u0003B\u00029\u0002X\u0001\u0007\u0011\u000f\u0003\u0004v\u0003/\u0002\rA\u001e")
public class ChannelStatsHandler
extends SimpleChannelHandler {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public final AtomicLong com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount = new AtomicLong();
    private Function0<Duration> elapsed = null;
    private final Counter connects;
    private final Stat connectionDuration;
    private final Stat connectionReceivedBytes;
    private final Stat connectionSentBytes;
    private final Counter receivedBytes;
    private final Counter sentBytes;
    private final Counter writable;
    private final Counter unwritable;
    private final StatsReceiver exceptions;
    private final Counter closesCount;
    private final Gauge connections;
    private boolean hasBeenWritable;
    private Time since;

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.elapsed = Stopwatch$.MODULE$.start();
        ctx.setAttachment((Object)new Tuple2((Object)new AtomicLong(0L), (Object)new AtomicLong(0L)));
        this.connects.incr();
        this.com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount.incrementAndGet();
        super.channelOpen(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        Tuple2 tuple2 = (Tuple2)ctx.getAttachment();
        if (tuple2 != null) {
            AtomicLong channelWriteCount;
            AtomicLong atomicLong;
            AtomicLong channelWriteCount2 = atomicLong = (channelWriteCount = (AtomicLong)tuple2._2());
            channelWriteCount2.getAndAdd(e.getWrittenAmount());
            this.sentBytes.incr((int)e.getWrittenAmount());
            super.writeComplete(ctx, e);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (object instanceof ChannelBuffer) {
            AtomicLong channelReadCount;
            AtomicLong atomicLong;
            ChannelBuffer channelBuffer = (ChannelBuffer)object;
            Tuple2 tuple2 = (Tuple2)ctx.getAttachment();
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            AtomicLong channelReadCount2 = atomicLong = (channelReadCount = (AtomicLong)tuple2._1());
            int readableBytes = channelBuffer.readableBytes();
            channelReadCount2.getAndAdd(readableBytes);
            this.receivedBytes.incr(readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer read");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.messageReceived(ctx, e);
    }

    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.closesCount.incr();
        super.closeRequested(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Tuple2 tuple2;
        block4: {
            block3: {
                Tuple2 tuple22;
                Object object;
                block2: {
                    if (this.elapsed != null) break block2;
                    object = BoxedUnit.UNIT;
                    break block3;
                }
                tuple2 = (Tuple2)ctx.getAttachment();
                if (tuple2 == null) break block4;
                AtomicLong channelReadCount = (AtomicLong)tuple2._1();
                AtomicLong channelWriteCount = (AtomicLong)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)channelReadCount, (Object)channelWriteCount);
                AtomicLong channelReadCount2 = (AtomicLong)tuple23._1();
                AtomicLong channelWriteCount2 = (AtomicLong)tuple23._2();
                this.connectionReceivedBytes.add((float)channelReadCount2.get());
                this.connectionSentBytes.add((float)channelWriteCount2.get());
                this.connectionDuration.add((float)((TimeLike)this.elapsed.apply()).inMilliseconds());
                object = BoxesRunTime.boxToLong((long)this.com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount.decrementAndGet());
            }
            super.channelClosed(ctx, e);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent evt) {
        String m = evt.getCause() == null ? "unknown" : evt.getCause().getClass().getName();
        this.exceptions.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{m})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Throwable throwable = evt.getCause();
            Level level = throwable instanceof IOException ? Level.FINE : Level.WARNING;
            Level level2 = level;
            this.log.log(level2, "ChannelStatsHandler caught an exception", evt.getCause());
        }
        super.exceptionCaught(ctx, evt);
    }

    private Duration socketDuration(Time now) {
        return now.$minus(this.since);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Time now = Time$.MODULE$.now();
        super.channelInterestChanged(ctx, e);
        boolean isWritable = ctx.getChannel().isWritable();
        if (isWritable != this.hasBeenWritable) {
            Counter stat = this.hasBeenWritable ? this.writable : this.unwritable;
            stat.incr((int)this.socketDuration(now).inMillis());
            this.hasBeenWritable = isWritable;
            this.since = now;
        }
    }

    public ChannelStatsHandler(StatsReceiver statsReceiver) {
        this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
        this.connectionDuration = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
        this.connectionReceivedBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
        this.connectionSentBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
        this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
        this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
        this.writable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
        this.unwritable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
        this.exceptions = statsReceiver.scope("exn");
        this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
        this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChannelStatsHandler $outer;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return this.$outer.com$twitter$finagle$netty3$channel$ChannelStatsHandler$$connectionCount.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.hasBeenWritable = true;
        this.since = Time$.MODULE$.now();
    }
}

