/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.exp;

import com.twitter.concurrent.BridgedThreadPoolScheduler;
import com.twitter.concurrent.LocalScheduler;
import com.twitter.concurrent.Scheduler;
import com.twitter.concurrent.Scheduler$;
import com.twitter.finagle.exp.FinagleScheduler$Integer$;
import com.twitter.finagle.exp.ForkJoinScheduler;
import com.twitter.finagle.exp.scheduler$;
import com.twitter.finagle.stats.DefaultStatsReceiver$;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.util.package$;
import com.twitter.jvm.numProcs$;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class FinagleScheduler$ {
    public static final FinagleScheduler$ MODULE$;
    private final Logger log;
    private final MutableList<Gauge> gauges;

    static {
        new FinagleScheduler$();
    }

    private Logger log() {
        return this.log;
    }

    private void switchToBridged(int numWorkers2) {
        LinkedTransferQueue queue = new LinkedTransferQueue();
        Scheduler$.MODULE$.setUnsafe((Scheduler)new BridgedThreadPoolScheduler("bridged scheduler", (Function1)new Serializable(numWorkers2, queue){
            public static final long serialVersionUID = 0L;
            private final int numWorkers$1;
            private final LinkedTransferQueue queue$1;

            public final ThreadPoolExecutor apply(ThreadFactory threadFactory) {
                return new ThreadPoolExecutor(this.numWorkers$1, this.numWorkers$1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.queue$1, threadFactory);
            }
            {
                this.numWorkers$1 = numWorkers$1;
                this.queue$1 = queue$1;
            }
        }));
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Using bridged scheduler with %d workers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numWorkers2)})));
    }

    private void switchToForkJoin(int numWorkers2) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Using forkjoin scheduler with %d workers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numWorkers2)})));
        Scheduler$.MODULE$.setUnsafe((Scheduler)new ForkJoinScheduler(numWorkers2, DefaultStatsReceiver$.MODULE$.scope("forkjoin")));
    }

    public void addGauges(Scheduler scheduler2, StatsReceiver statsReceiver, MutableList<Gauge> gauges) {
        MutableList<Gauge> mutableList = gauges;
        synchronized (mutableList) {
            gauges.$plus$eq((Object)statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dispatches"}), (Function0)new Serializable(scheduler2){
                public static final long serialVersionUID = 0L;
                private final Scheduler scheduler$1;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return this.scheduler$1.numDispatches();
                }
                {
                    this.scheduler$1 = scheduler$1;
                }
            }));
            gauges.$plus$eq((Object)statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blocking_ms"}), (Function0)new Serializable(scheduler2){
                public static final long serialVersionUID = 0L;
                private final Scheduler scheduler$1;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return TimeUnit.NANOSECONDS.toMillis(this.scheduler$1.blockingTimeNanos());
                }
                {
                    this.scheduler$1 = scheduler$1;
                }
            }));
            return;
        }
    }

    public void init() {
        block8: {
            block3: {
                .colon.colon colon2;
                boolean bl;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    bl = false;
                                    colon2 = null;
                                    List list = Predef$.MODULE$.refArrayOps((Object[])((String)scheduler$.MODULE$.apply()).split(":")).toList();
                                    if (!(list instanceof .colon.colon)) break block2;
                                    bl = true;
                                    colon2 = (.colon.colon)list;
                                    String string = (String)colon2.head();
                                    List list2 = colon2.tl$1();
                                    if (!"bridged".equals(string) || !(list2 instanceof .colon.colon)) break block2;
                                    .colon.colon colon3 = (.colon.colon)list2;
                                    String string2 = (String)colon3.head();
                                    List list3 = colon3.tl$1();
                                    Option<Object> option = FinagleScheduler$Integer$.MODULE$.unapply(string2);
                                    if (option.isEmpty()) break block2;
                                    int numWorkers2 = BoxesRunTime.unboxToInt((Object)option.get());
                                    if (!Nil$.MODULE$.equals(list3)) break block2;
                                    this.switchToBridged(numWorkers2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!bl) break block4;
                                String string = (String)colon2.head();
                                List list = colon2.tl$1();
                                if (!"bridged".equals(string) || !Nil$.MODULE$.equals(list)) break block4;
                                this.switchToBridged((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)numProcs$.MODULE$.apply()))));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!bl) break block5;
                            String string = (String)colon2.head();
                            List list = colon2.tl$1();
                            if (!"forkjoin".equals(string) || !(list instanceof .colon.colon)) break block5;
                            .colon.colon colon4 = (.colon.colon)list;
                            String string3 = (String)colon4.head();
                            List list4 = colon4.tl$1();
                            Option<Object> option = FinagleScheduler$Integer$.MODULE$.unapply(string3);
                            if (option.isEmpty()) break block5;
                            int numWorkers3 = BoxesRunTime.unboxToInt((Object)option.get());
                            if (!Nil$.MODULE$.equals(list4)) break block5;
                            this.switchToForkJoin(numWorkers3);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!bl) break block6;
                        String string = (String)colon2.head();
                        List list = colon2.tl$1();
                        if (!"forkjoin".equals(string) || !Nil$.MODULE$.equals(list)) break block6;
                        this.switchToForkJoin((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)numProcs$.MODULE$.apply()))));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!bl) break block7;
                    String string = (String)colon2.head();
                    List list = colon2.tl$1();
                    if (!"lifo".equals(string) || !Nil$.MODULE$.equals(list)) break block7;
                    this.log().info("Using LIFO local scheduler");
                    Scheduler$.MODULE$.setUnsafe((Scheduler)new LocalScheduler(true));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!bl) break block8;
                String string = (String)colon2.head();
                List list = colon2.tl$1();
                if (!"local".equals(string) || !Nil$.MODULE$.equals(list)) break block8;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.addGauges((Scheduler)Scheduler$.MODULE$, DefaultStatsReceiver$.MODULE$.scope("scheduler"), this.gauges);
            return;
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Wrong scheduler config: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheduler$.MODULE$.apply()})));
    }

    private FinagleScheduler$() {
        MODULE$ = this;
        this.log = package$.MODULE$.DefaultLogger();
        this.gauges = (MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

