/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.client;

import com.twitter.util.Closable;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Time;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q3Q!\u0001\u0002\u0001\t)\u0011!CU3gG>,h\u000e^3e\u00072|7/\u00192mK*\u00111\u0001B\u0001\u0007G2LWM\u001c;\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u000b\u0003\u0017u\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111CF\u0007\u0002))\u0011QCB\u0001\u0005kRLG.\u0003\u0002\u0018)\tA1\t\\8tC\ndW\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001c\u0003!\u0019Gn\\:bE2,7\u0001\u0001\t\u00039ua\u0001\u0001B\u0003\u001f\u0001\t\u0007qDA\u0001U#\t\u0001#\u0003\u0005\u0002\u000eC%\u0011!E\u0004\u0002\b\u001d>$\b.\u001b8h\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0004O\u0001YR\"\u0001\u0002\t\u000be\u0019\u0003\u0019A\u000e\t\r)\u0002\u0001\u0015!\u0003,\u0003\u0015\u0019w.\u001e8u!\taC'D\u0001.\u0015\tqs&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003aE\n!bY8oGV\u0014(/\u001a8u\u0015\t)\"GC\u00014\u0003\u0011Q\u0017M^1\n\u0005Uj#!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u00048\u0001\u0001\u0006I\u0001O\u0001\tSN\u001cEn\\:fIB\u0011A&O\u0005\u0003u5\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007B\u0002\u001f\u0001A\u0003%Q(A\u0004dY>\u001cX\r\u001a)\u0011\u0007Mq\u0004)\u0003\u0002@)\t9\u0001K]8nSN,\u0007CA\u0007B\u0013\t\u0011eB\u0001\u0003V]&$\b\"\u0002#\u0001\t\u0003)\u0015aA4fiV\t1\u0004C\u0003H\u0001\u0011\u0005\u0001*\u0001\u0003pa\u0016tG#\u0001!\t\u000b)\u0003A\u0011I&\u0002\u000b\rdwn]3\u0015\u00051{\u0005cA\nN\u0001&\u0011a\n\u0006\u0002\u0007\rV$XO]3\t\u000bAK\u0005\u0019A)\u0002\u0011\u0011,\u0017\r\u001a7j]\u0016\u0004\"a\u0005*\n\u0005M#\"\u0001\u0002+j[\u0016\u0004")
public class RefcountedClosable<T extends Closable>
implements Closable {
    private final T closable;
    private final AtomicInteger count;
    private final AtomicBoolean isClosed;
    private final Promise<BoxedUnit> closedP;

    public final Future<BoxedUnit> close() {
        return Closable.class.close((Closable)this);
    }

    public Future<BoxedUnit> close(Duration after) {
        return Closable.class.close((Closable)this, (Duration)after);
    }

    public T get() {
        return this.closable;
    }

    public void open() {
        this.count.incrementAndGet();
    }

    public Future<BoxedUnit> close(Time deadline) {
        if (this.count.decrementAndGet() == 0 && this.isClosed.compareAndSet(false, true)) {
            this.closedP.become(this.closable.close(deadline));
        }
        return this.closedP;
    }

    public RefcountedClosable(T closable) {
        this.closable = closable;
        Closable.class.$init$((Closable)this);
        this.count = new AtomicInteger(0);
        this.isClosed = new AtomicBoolean(false);
        this.closedP = new Promise();
    }
}

