/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.twitter.finagle.DnsResolver;
import com.twitter.finagle.FixedInetResolver;
import com.twitter.finagle.FixedInetResolver$;
import com.twitter.finagle.FixedInetResolver$$anon$2$$anonfun$com$twitter$finagle$FixedInetResolver$$anon$;
import com.twitter.finagle.InetResolver;
import com.twitter.finagle.stats.DefaultStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.util.DefaultTimer$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.FuturePool$;
import com.twitter.util.Timer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.package$;

public final class FixedInetResolver$ {
    public static final FixedInetResolver$ MODULE$;
    public final Logger com$twitter$finagle$FixedInetResolver$$log;
    private final String scheme;

    static {
        new FixedInetResolver$();
    }

    public String scheme() {
        return this.scheme;
    }

    public InetResolver apply() {
        return this.apply((StatsReceiver)DefaultStatsReceiver$.MODULE$);
    }

    public InetResolver apply(StatsReceiver unscopedStatsReceiver) {
        return this.apply(unscopedStatsReceiver, 16000L);
    }

    public InetResolver apply(StatsReceiver unscopedStatsReceiver, long maxCacheSize) {
        return this.apply(unscopedStatsReceiver, maxCacheSize, (Stream<Duration>)package$.MODULE$.Stream().empty(), DefaultTimer$.MODULE$.twitter());
    }

    public InetResolver apply(StatsReceiver unscopedStatsReceiver, long maxCacheSize, Stream<Duration> backoffs, Timer timer) {
        StatsReceiver statsReceiver = unscopedStatsReceiver.scope("inet").scope("dns");
        return new FixedInetResolver(this.cache(new DnsResolver(statsReceiver, FuturePool$.MODULE$.unboundedPool()), maxCacheSize, backoffs, timer), statsReceiver);
    }

    public LoadingCache<String, Future<Seq<InetAddress>>> cache(Function1<String, Future<Seq<InetAddress>>> resolveHost, long maxCacheSize, Stream<Duration> backoffs, Timer timer) {
        CacheLoader<String, Future<Seq<InetAddress>>> cacheLoader = new CacheLoader<String, Future<Seq<InetAddress>>>(resolveHost, backoffs, timer){
            private final Function1 resolveHost$1;
            private final Stream backoffs$1;
            public final Timer timer$1;

            public Future<Seq<InetAddress>> load(String host) {
                return this.com$twitter$finagle$FixedInetResolver$$anon$$retryingLoad$1(this.backoffs$1, host);
            }

            public final Future com$twitter$finagle$FixedInetResolver$$anon$$retryingLoad$1(Stream nextBackoffs, String host$2) {
                return ((Future)this.resolveHost$1.apply((Object)host$2)).rescue((PartialFunction)new Serializable(this, host$2, nextBackoffs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;
                    public final String host$2;
                    private final Stream nextBackoffs$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 instanceof UnknownHostException) {
                            Future future;
                            UnknownHostException unknownHostException = (UnknownHostException)A1;
                            Stream stream = this.nextBackoffs$1;
                            Option option = package$.MODULE$.$hash$colon$colon().unapply(stream);
                            if (option.isEmpty()) {
                                if (!Stream.Empty$.MODULE$.equals(stream)) throw new MatchError((Object)stream);
                                future = Future$.MODULE$.exception((Throwable)unknownHostException);
                            } else {
                                Duration nextBackoff = (Duration)((Tuple2)option.get())._1();
                                Stream restBackoffs = (Stream)((Tuple2)option.get())._2();
                                FixedInetResolver$.MODULE$.com$twitter$finagle$FixedInetResolver$$log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Caught UnknownHostException resolving host '", "'. Retrying in ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$2, nextBackoff})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                future = Future$.MODULE$.sleep(nextBackoff, this.$outer.timer$1).before((Function0)new Serializable(this, restBackoffs){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anon$2$$anonfun$com$twitter$finagle$FixedInetResolver$$anon$$retryingLoad$1$1 $outer;
                                    private final Stream restBackoffs$1;

                                    public final Future<Seq<InetAddress>> apply() {
                                        return this.$outer.com$twitter$finagle$FixedInetResolver$$anon$$anonfun$$$outer().com$twitter$finagle$FixedInetResolver$$anon$$retryingLoad$1(this.restBackoffs$1, this.$outer.host$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.restBackoffs$1 = restBackoffs$1;
                                    }
                                }, Predef$.MODULE$.$conforms());
                            }
                            object = future;
                            return (B1)object;
                        } else {
                            object = function1.apply(x3);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x3) {
                        Throwable throwable = x3;
                        boolean bl = throwable instanceof UnknownHostException;
                        return bl;
                    }

                    public /* synthetic */ anon.2 com$twitter$finagle$FixedInetResolver$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.host$2 = host$2;
                        this.nextBackoffs$1 = nextBackoffs$1;
                    }
                });
            }
            {
                this.resolveHost$1 = resolveHost$1;
                this.backoffs$1 = backoffs$1;
                this.timer$1 = timer$1;
            }
        };
        Caffeine builder = Caffeine.newBuilder().recordStats();
        if (maxCacheSize != Long.MAX_VALUE) {
            builder = builder.maximumSize(maxCacheSize);
        }
        return builder.build((CacheLoader)cacheLoader);
    }

    public Stream<Duration> cache$default$3() {
        return package$.MODULE$.Stream().empty();
    }

    public Timer cache$default$4() {
        return DefaultTimer$.MODULE$.twitter();
    }

    private FixedInetResolver$() {
        MODULE$ = this;
        this.com$twitter$finagle$FixedInetResolver$$log = Logger$.MODULE$.apply();
        this.scheme = "fixedinet";
    }
}

