/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle;

import com.twitter.finagle.Failure;
import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.logging.HasLogLevel$;
import com.twitter.logging.Level;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

public final class Failure$
implements Serializable {
    public static final Failure$ MODULE$;
    private final long Restartable;
    private final long Interrupted;
    private final long Wrapped;
    private final long Rejected;
    private final long NonRetryable;
    private final long Naming;
    private final long ShowMask;
    private final Failure rejected;
    private final Stack.Role role;

    static {
        new Failure$();
    }

    public long Restartable() {
        return this.Restartable;
    }

    public long Interrupted() {
        return this.Interrupted;
    }

    public long Wrapped() {
        return this.Wrapped;
    }

    public long Rejected() {
        return this.Rejected;
    }

    public long NonRetryable() {
        return this.NonRetryable;
    }

    public long Naming() {
        return this.Naming;
    }

    private long ShowMask() {
        return this.ShowMask;
    }

    public Failure apply(Throwable cause, long flags, Level logLevel) {
        Failure failure;
        if (cause == null) {
            String x$21 = "unknown";
            None$ x$22 = None$.MODULE$;
            long x$23 = flags;
            Level x$24 = logLevel;
            Map<Enumeration.Value, Object> x$25 = this.$lessinit$greater$default$4();
            failure = new Failure(x$21, (Option<Throwable>)x$22, x$23, x$25, x$24);
        } else if (cause.getMessage() == null) {
            String x$26 = cause.getClass().getName();
            Some x$27 = new Some((Object)cause);
            long x$28 = flags;
            Level x$29 = logLevel;
            Map<Enumeration.Value, Object> x$30 = this.$lessinit$greater$default$4();
            failure = new Failure(x$26, (Option<Throwable>)x$27, x$28, x$30, x$29);
        } else {
            String x$31 = cause.getMessage();
            Some x$32 = new Some((Object)cause);
            long x$33 = flags;
            Level x$34 = logLevel;
            Map<Enumeration.Value, Object> x$35 = this.$lessinit$greater$default$4();
            failure = new Failure(x$31, (Option<Throwable>)x$32, x$33, x$35, x$34);
        }
        return failure;
    }

    private Level computeLogLevel(Throwable t) {
        Level.WARNING$ wARNING$;
        Throwable throwable = t;
        Option option = HasLogLevel$.MODULE$.unapply(throwable);
        if (option.isEmpty()) {
            wARNING$ = Level.WARNING$.MODULE$;
        } else {
            Level level = (Level)option.get();
            wARNING$ = level;
        }
        return wARNING$;
    }

    public Failure apply(Throwable cause) {
        return this.apply(cause, 0L, this.computeLogLevel(cause));
    }

    public Failure apply(String why, Throwable cause, long flags) {
        String x$36 = why;
        Option x$37 = Option$.MODULE$.apply((Object)cause);
        long x$38 = flags;
        Level x$39 = this.computeLogLevel(cause);
        Map<Enumeration.Value, Object> x$40 = this.$lessinit$greater$default$4();
        return new Failure(x$36, (Option<Throwable>)x$37, x$38, x$40, x$39);
    }

    public Failure apply(String why, Throwable cause) {
        String x$41 = why;
        Option x$42 = Option$.MODULE$.apply((Object)cause);
        long x$43 = 0L;
        Level x$44 = this.computeLogLevel(cause);
        Map<Enumeration.Value, Object> x$45 = this.$lessinit$greater$default$4();
        return new Failure(x$41, (Option<Throwable>)x$42, x$43, x$45, x$44);
    }

    public Failure apply(String why, long flags) {
        return new Failure(why, (Option<Throwable>)None$.MODULE$, flags, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5());
    }

    public Failure apply(String why) {
        return new Failure(why, (Option<Throwable>)None$.MODULE$, 0L, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5());
    }

    public Level apply$default$3() {
        return Level.WARNING$.MODULE$;
    }

    public Option<Option<Throwable>> unapply(Failure exc) {
        return new Some(exc.cause());
    }

    public Set<String> flagsOf(Throwable exc) {
        Set<String> set2;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure = (Failure)throwable;
            set2 = FailureFlags$.MODULE$.flagsOf(failure.flags());
        } else {
            set2 = Predef$.MODULE$.Set().empty();
        }
        return set2;
    }

    public Failure adapt(Throwable exc, long flags) {
        Failure failure;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure2 = (Failure)throwable;
            failure = (Failure)failure2.chained().flagged(flags);
        } else {
            failure = this.apply(exc, flags, this.computeLogLevel(exc));
        }
        return failure;
    }

    public Failure wrap(Throwable exc, long flags) {
        Failure failure;
        Predef$.MODULE$.require(exc != null);
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure2 = (Failure)throwable;
            failure = (Failure)failure2.flagged(flags | this.Wrapped());
        } else {
            failure = this.apply(exc, flags | this.Wrapped(), this.computeLogLevel(exc));
        }
        return failure;
    }

    public Failure wrap(Throwable exc) {
        return this.wrap(exc, 0L);
    }

    public Failure rejected(String why) {
        String x$46 = why;
        None$ x$47 = None$.MODULE$;
        long x$48 = FailureFlags$.MODULE$.Retryable() | FailureFlags$.MODULE$.Rejected();
        Level.DEBUG$ x$49 = Level.DEBUG$.MODULE$;
        Map<Enumeration.Value, Object> x$50 = this.$lessinit$greater$default$4();
        return new Failure(x$46, (Option<Throwable>)x$47, x$48, x$50, (Level)x$49);
    }

    public Failure rejected(Throwable cause) {
        return this.apply(cause, FailureFlags$.MODULE$.Retryable() | FailureFlags$.MODULE$.Rejected(), (Level)Level.DEBUG$.MODULE$);
    }

    public Failure rejected(String why, Throwable cause) {
        String x$51 = why;
        Option x$52 = Option$.MODULE$.apply((Object)cause);
        long x$53 = FailureFlags$.MODULE$.Retryable() | FailureFlags$.MODULE$.Rejected();
        Level.DEBUG$ x$54 = Level.DEBUG$.MODULE$;
        Map<Enumeration.Value, Object> x$55 = this.$lessinit$greater$default$4();
        return new Failure(x$51, (Option<Throwable>)x$52, x$53, x$55, (Level)x$54);
    }

    public Failure rejected() {
        return this.rejected;
    }

    public Throwable com$twitter$finagle$Failure$$show(Failure f) {
        Throwable throwable;
        block5: {
            while (f.isFlagged(FailureFlags$.MODULE$.Wrapped())) {
                Throwable inner;
                boolean bl = false;
                Some some = null;
                Option<Throwable> option = f.cause();
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    Throwable inner2 = (Throwable)some.x();
                    if (inner2 instanceof Failure) {
                        Failure failure;
                        f = failure = (Failure)inner2;
                        continue;
                    }
                }
                if (bl && (inner = (Throwable)some.x()) != null) {
                    Throwable throwable2;
                    Throwable throwable3;
                    throwable = throwable3 = (throwable2 = inner);
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException("Wrapped failure without a cause");
                }
                throw new MatchError(option);
            }
            throwable = (Throwable)((Object)f.masked(this.ShowMask()));
        }
        return throwable;
    }

    public Stack.Role role() {
        return this.role;
    }

    public <Req, Rep> Stackable<ServiceFactory<Req, Rep>> module() {
        return new Stack.Module0<ServiceFactory<Req, Rep>>(){
            private final Stack.Role role;
            private final String description;
            private final Failure.ProcessFailures<Req, Rep> filter;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Req, Rep> make(ServiceFactory<Req, Rep> next2) {
                return this.filter.andThen(next2);
            }
            {
                this.role = Failure$.MODULE$.role();
                this.description = "process failures";
                this.filter = new Failure.ProcessFailures<Req, Rep>();
            }
        };
    }

    public Option<Throwable> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public long $lessinit$greater$default$3() {
        return FailureFlags$.MODULE$.Empty();
    }

    public Map<Enumeration.Value, Object> $lessinit$greater$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public Level $lessinit$greater$default$5() {
        return Level.WARNING$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Failure$() {
        MODULE$ = this;
        this.Restartable = FailureFlags$.MODULE$.Retryable();
        this.Interrupted = FailureFlags$.MODULE$.Interrupted();
        this.Wrapped = FailureFlags$.MODULE$.Wrapped();
        this.Rejected = FailureFlags$.MODULE$.Rejected();
        this.NonRetryable = FailureFlags$.MODULE$.NonRetryable();
        this.Naming = FailureFlags$.MODULE$.Naming();
        this.ShowMask = FailureFlags$.MODULE$.ShowMask();
        this.rejected = this.rejected("The request was rejected");
        this.role = new Stack.Role("ProcessFailure");
    }
}

