/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.wagon;

import io.tesla.aether.client.AetherClient;
import io.tesla.aether.client.AetherClientAuthentication;
import io.tesla.aether.client.AetherClientConfig;
import io.tesla.aether.client.AetherClientProxy;
import io.tesla.aether.client.Response;
import io.tesla.aether.okhttp.OkHttpAetherClient;
import java.io.IOException;
import java.util.Properties;
import javax.inject.Named;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.component.annotations.Component;

@Named(value="http")
@Component(role=Wagon.class, hint="http", instantiationStrategy="per-lookup")
public class OkHttpWagon
extends StreamWagon {
    private Properties httpHeaders;
    private AetherClient client;

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        String url = this.buildUrl(resource.getName());
        try {
            Response response = this.client.get(url);
            inputData.setInputStream(response.getInputStream());
        }
        catch (IOException e) {
            StringBuilder message = new StringBuilder("Error transferring file: ");
            message.append(e.getMessage());
            message.append(" from " + url);
            if (this.getProxyInfo() != null && this.getProxyInfo().getHost() != null) {
                message.append(" with proxyInfo ").append(this.getProxyInfo().toString());
            }
            throw new TransferFailedException(message.toString(), (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Resource resource = outputData.getResource();
        String url = this.buildUrl(resource.getName());
        try {
            Response response = this.client.put(url);
            outputData.setOutputStream(response.getOutputStream());
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection() throws ConnectionException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                throw new ConnectionException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        AetherClientConfig config = new AetherClientConfig();
        config.setUserAgent("Maven-Wagon/1.0");
        if (this.httpHeaders != null) {
            config.setHeaders(this.httpHeaders);
        }
        if (this.getProxyInfo() != null) {
            AetherClientProxy proxy = new AetherClientProxy();
            proxy.setHost(this.getProxyInfo().getHost());
            proxy.setPort(this.getProxyInfo().getPort());
            if (this.getProxyInfo().getUserName() != null && this.getProxyInfo().getPassword() != null) {
                String username = this.getProxyInfo().getUserName();
                String password = this.getProxyInfo().getPassword();
                proxy.setAuthentication(new AetherClientAuthentication(username, password));
            }
            config.setProxy(proxy);
        }
        if (this.getAuthenticationInfo() != null) {
            String username = this.getAuthenticationInfo().getUserName();
            String password = this.getAuthenticationInfo().getPassword();
            AetherClientAuthentication authentication = new AetherClientAuthentication(username, password);
            config.setAuthentication(authentication);
        }
        config.setConnectionTimeout(10000);
        config.setRequestTimeout(1800000);
        this.client = new OkHttpAetherClient(config);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            String url = this.buildUrl(resourceName);
            Response response = this.client.head(url);
            int statusCode = response.getStatusCode();
            switch (statusCode) {
                case 200: {
                    return true;
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 404: {
                    return false;
                }
                case 401: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
            }
            throw new TransferFailedException("Failed to look for file: " + this.buildUrl(resourceName) + ". Return code is: " + statusCode);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    private String buildUrl(String path) {
        String repoUrl = this.getRepository().getUrl();
        path = path.replace(' ', '+');
        if (repoUrl.charAt(repoUrl.length() - 1) != '/') {
            return repoUrl + '/' + path;
        }
        return repoUrl + path;
    }

    void setSystemProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.getProperties().remove(key);
        }
    }

    public void setHttpHeaders(Properties httpHeaders) {
        System.out.println(">>>>> " + httpHeaders);
        this.httpHeaders = httpHeaders;
    }
}

