/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import scala.runtime.BoxedUnit;

@ChannelHandler.Sharable
public final class DirectToHeapInboundHandler$
extends ChannelInboundHandlerAdapter {
    public static final DirectToHeapInboundHandler$ MODULE$;

    static {
        new DirectToHeapInboundHandler$();
    }

    private final ByteBuf copyOnHeap(ByteBuf bb) {
        try {
            return Unpooled.buffer((int)bb.readableBytes(), (int)bb.capacity()).writeBytes(bb);
        }
        finally {
            bb.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf byteBuf;
        boolean bl = false;
        ByteBufHolder byteBufHolder = null;
        Object object = msg;
        if (object instanceof EmptyByteBuf) {
            EmptyByteBuf emptyByteBuf = (EmptyByteBuf)object;
            ctx.fireChannelRead((Object)emptyByteBuf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (object instanceof ByteBuf && (byteBuf = (ByteBuf)object).isDirect()) {
            ctx.fireChannelRead((Object)this.copyOnHeap(byteBuf));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (object instanceof ByteBufHolder) {
            bl = true;
            byteBufHolder = (ByteBufHolder)object;
            if (byteBufHolder.content() instanceof EmptyByteBuf) {
                ctx.fireChannelRead((Object)byteBufHolder);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && byteBufHolder.content().isDirect()) {
            ByteBuf onHeapContent = this.copyOnHeap(byteBufHolder.content());
            ctx.fireChannelRead((Object)byteBufHolder.replace(onHeapContent));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        ctx.fireChannelRead(msg);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DirectToHeapInboundHandler$() {
        MODULE$ = this;
    }
}

