/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections;

import com.google.common.collect.Sets;
import com.metamx.collections.bitmap.MutableBitmap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.roaringbitmap.IntIterator;

public class IntegerSet
implements Set<Integer> {
    private final MutableBitmap mutableBitmap;

    private IntegerSet(MutableBitmap mutableBitmap) {
        this.mutableBitmap = mutableBitmap;
    }

    public static IntegerSet wrap(MutableBitmap mutableBitmap) {
        return new IntegerSet(mutableBitmap);
    }

    @Override
    public int size() {
        return this.mutableBitmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mutableBitmap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.mutableBitmap.get((Integer)o);
        }
        if (o instanceof Long) {
            return this.contains(((Long)o).intValue());
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new BitSetIterator(this.mutableBitmap);
    }

    @Override
    public Object[] toArray() {
        Object[] retval = new Integer[this.mutableBitmap.size()];
        int pos = 0;
        for (Integer i : this) {
            retval[pos++] = i;
        }
        return retval;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Sets.newHashSet((Iterable)this).toArray(a);
    }

    @Override
    public boolean add(Integer integer) {
        if (null == integer) {
            throw new NullPointerException("BitSet cannot contain null values");
        }
        if (integer < 0) {
            throw new IllegalArgumentException("Only positive integers or zero can be added");
        }
        boolean isSet = this.mutableBitmap.get(integer);
        this.mutableBitmap.add(integer);
        return !isSet;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException("BitSet cannot contain null values");
        }
        if (o instanceof Integer) {
            Integer integer = (Integer)o;
            boolean isSet = this.mutableBitmap.get(integer);
            this.mutableBitmap.remove(integer);
            return isSet;
        }
        throw new ClassCastException("Cannot remove non Integer from integer BitSet");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        boolean setChanged = false;
        for (Integer n : c) {
            if (this.contains(n)) continue;
            setChanged = true;
            this.add(n);
        }
        return setChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot retainAll ona an IntegerSet");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            Integer val = (Integer)it.next();
            changed = this.remove(val) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.mutableBitmap.clear();
    }

    public static class BitSetIterator
    implements Iterator<Integer> {
        private final IntIterator intIt;
        private final MutableBitmap bitSet;
        private Integer prior = null;

        public BitSetIterator(MutableBitmap bitSet) {
            this.intIt = bitSet.iterator();
            this.bitSet = bitSet;
        }

        @Override
        public boolean hasNext() {
            return this.intIt.hasNext();
        }

        @Override
        public Integer next() {
            this.prior = this.intIt.next();
            return this.prior;
        }

        @Override
        public void remove() {
            this.bitSet.remove(this.prior);
        }
    }
}

