/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.BouncedRecipientInfo;
import com.amazonaws.services.simpleemail.model.ExtensionField;
import com.amazonaws.services.simpleemail.model.MessageDsn;
import com.amazonaws.services.simpleemail.model.RecipientDsnFields;
import com.amazonaws.services.simpleemail.model.SendBounceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class SendBounceRequestMarshaller
implements Marshaller<Request<SendBounceRequest>, SendBounceRequest> {
    public Request<SendBounceRequest> marshall(SendBounceRequest sendBounceRequest) {
        MessageDsn messageDsnMessageDsn;
        if (sendBounceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendBounceRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendBounce");
        request.addParameter("Version", "2010-12-01");
        if (sendBounceRequest.getOriginalMessageId() != null) {
            request.addParameter("OriginalMessageId", StringUtils.fromString((String)sendBounceRequest.getOriginalMessageId()));
        }
        if (sendBounceRequest.getBounceSender() != null) {
            request.addParameter("BounceSender", StringUtils.fromString((String)sendBounceRequest.getBounceSender()));
        }
        if (sendBounceRequest.getExplanation() != null) {
            request.addParameter("Explanation", StringUtils.fromString((String)sendBounceRequest.getExplanation()));
        }
        if ((messageDsnMessageDsn = sendBounceRequest.getMessageDsn()) != null) {
            if (messageDsnMessageDsn.getReportingMta() != null) {
                request.addParameter("MessageDsn.ReportingMta", StringUtils.fromString((String)messageDsnMessageDsn.getReportingMta()));
            }
            if (messageDsnMessageDsn.getArrivalDate() != null) {
                request.addParameter("MessageDsn.ArrivalDate", StringUtils.fromDate((Date)messageDsnMessageDsn.getArrivalDate()));
            }
            List<ExtensionField> extensionFieldsList = messageDsnMessageDsn.getExtensionFields();
            int extensionFieldsListIndex = 1;
            for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                ExtensionField extensionFieldMember = extensionFieldsListValue;
                if (extensionFieldMember != null) {
                    if (extensionFieldMember.getName() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString((String)extensionFieldMember.getName()));
                    }
                    if (extensionFieldMember.getValue() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString((String)extensionFieldMember.getValue()));
                    }
                }
                ++extensionFieldsListIndex;
            }
        }
        List<BouncedRecipientInfo> bouncedRecipientInfoListList = sendBounceRequest.getBouncedRecipientInfoList();
        int bouncedRecipientInfoListListIndex = 1;
        for (BouncedRecipientInfo bouncedRecipientInfoListListValue : bouncedRecipientInfoListList) {
            BouncedRecipientInfo bouncedRecipientInfoMember = bouncedRecipientInfoListListValue;
            if (bouncedRecipientInfoMember != null) {
                RecipientDsnFields recipientDsnFieldsRecipientDsnFields;
                if (bouncedRecipientInfoMember.getRecipient() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".Recipient", StringUtils.fromString((String)bouncedRecipientInfoMember.getRecipient()));
                }
                if (bouncedRecipientInfoMember.getRecipientArn() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientArn", StringUtils.fromString((String)bouncedRecipientInfoMember.getRecipientArn()));
                }
                if (bouncedRecipientInfoMember.getBounceType() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".BounceType", StringUtils.fromString((String)bouncedRecipientInfoMember.getBounceType()));
                }
                if ((recipientDsnFieldsRecipientDsnFields = bouncedRecipientInfoMember.getRecipientDsnFields()) != null) {
                    if (recipientDsnFieldsRecipientDsnFields.getFinalRecipient() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.FinalRecipient", StringUtils.fromString((String)recipientDsnFieldsRecipientDsnFields.getFinalRecipient()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getAction() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Action", StringUtils.fromString((String)recipientDsnFieldsRecipientDsnFields.getAction()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getRemoteMta() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.RemoteMta", StringUtils.fromString((String)recipientDsnFieldsRecipientDsnFields.getRemoteMta()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getStatus() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Status", StringUtils.fromString((String)recipientDsnFieldsRecipientDsnFields.getStatus()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getDiagnosticCode() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.DiagnosticCode", StringUtils.fromString((String)recipientDsnFieldsRecipientDsnFields.getDiagnosticCode()));
                    }
                    if (recipientDsnFieldsRecipientDsnFields.getLastAttemptDate() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.LastAttemptDate", StringUtils.fromDate((Date)recipientDsnFieldsRecipientDsnFields.getLastAttemptDate()));
                    }
                    List<ExtensionField> extensionFieldsList = recipientDsnFieldsRecipientDsnFields.getExtensionFields();
                    int extensionFieldsListIndex = 1;
                    for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                        ExtensionField extensionFieldMember = extensionFieldsListValue;
                        if (extensionFieldMember != null) {
                            if (extensionFieldMember.getName() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString((String)extensionFieldMember.getName()));
                            }
                            if (extensionFieldMember.getValue() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString((String)extensionFieldMember.getValue()));
                            }
                        }
                        ++extensionFieldsListIndex;
                    }
                }
            }
            ++bouncedRecipientInfoListListIndex;
        }
        if (sendBounceRequest.getBounceSenderArn() != null) {
            request.addParameter("BounceSenderArn", StringUtils.fromString((String)sendBounceRequest.getBounceSenderArn()));
        }
        return request;
    }
}

