/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.services.identitymanagement.model.Position;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PositionStaxUnmarshaller
implements Unmarshaller<Position, StaxUnmarshallerContext> {
    private static PositionStaxUnmarshaller instance;

    public Position unmarshall(StaxUnmarshallerContext context) throws Exception {
        Position position = new Position();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return position;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Line", targetDepth)) {
                    position.setLine(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Column", targetDepth)) continue;
                position.setColumn(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return position;
    }

    public static PositionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PositionStaxUnmarshaller();
        }
        return instance;
    }
}

