/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.service.ServiceEventBuilder;
import java.io.IOException;

public class ServiceEmitter
implements Emitter {
    private final ImmutableMap<String, String> serviceDimensions;
    private final Emitter emitter;

    public ServiceEmitter(String service, String host, Emitter emitter) {
        this(service, host, emitter, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public ServiceEmitter(String service, String host, Emitter emitter, ImmutableMap<String, String> otherServiceDimensions) {
        this.serviceDimensions = ImmutableMap.builder().put((Object)"service", Preconditions.checkNotNull((Object)service)).put((Object)"host", Preconditions.checkNotNull((Object)host)).putAll(otherServiceDimensions).build();
        this.emitter = emitter;
    }

    public String getService() {
        return (String)this.serviceDimensions.get((Object)"service");
    }

    public String getHost() {
        return (String)this.serviceDimensions.get((Object)"host");
    }

    @Override
    @LifecycleStart
    public void start() {
        this.emitter.start();
    }

    @Override
    public void emit(Event event) {
        this.emitter.emit(event);
    }

    public void emit(ServiceEventBuilder builder) {
        this.emit((Event)builder.build(this.serviceDimensions));
    }

    @Override
    public void flush() throws IOException {
        this.emitter.flush();
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        this.emitter.close();
    }
}

