/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import io.druid.data.input.InputRow;
import io.druid.timeline.partition.NumberedPartitionChunk;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.ShardSpecLookup;
import java.util.List;
import java.util.Map;

public class NumberedShardSpec
implements ShardSpec {
    @JsonIgnore
    private final int partitionNum;
    @JsonIgnore
    private final int partitions;

    @JsonCreator
    public NumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions) {
        Preconditions.checkArgument((partitionNum >= 0 ? 1 : 0) != 0, (Object)"partitionNum >= 0");
        Preconditions.checkArgument((partitions >= 0 ? 1 : 0) != 0, (Object)"partitions >= 0");
        this.partitionNum = partitionNum;
        this.partitions = partitions;
    }

    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            public ShardSpec getShardSpec(long timestamp, InputRow row) {
                return (ShardSpec)shardSpecs.get(0);
            }
        };
    }

    public Map<String, Range<String>> getDomain() {
        return ImmutableMap.of();
    }

    @JsonProperty(value="partitions")
    public int getPartitions() {
        return this.partitions;
    }

    public <T> PartitionChunk<T> createChunk(T obj) {
        return NumberedPartitionChunk.make((int)this.partitionNum, (int)this.partitions, obj);
    }

    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return true;
    }

    public String toString() {
        return "NumberedShardSpec{partitionNum=" + this.partitionNum + ", partitions=" + this.partitions + '}';
    }
}

