/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.server.coordinator.BalancerStrategyFactory;
import io.druid.server.coordinator.CostBalancerStrategy;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;

public class CostBalancerStrategyFactory
implements BalancerStrategyFactory {
    private final ListeningExecutorService exec;

    public CostBalancerStrategyFactory(int costBalancerStrategyThreadCount) {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(costBalancerStrategyThreadCount));
    }

    @Override
    public CostBalancerStrategy createBalancerStrategy(DateTime referenceTimestamp) {
        return new CostBalancerStrategy(this.exec);
    }

    @Override
    public void close() throws IOException {
        this.exec.shutdownNow();
    }
}

