/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.guice.annotations.Processing;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.plumber.FlushingPlumber;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import io.druid.server.coordination.DataSegmentAnnouncer;
import java.util.concurrent.ExecutorService;
import org.joda.time.Duration;

public class FlushingPlumberSchool
extends RealtimePlumberSchool {
    private static final Duration defaultFlushDuration = new Duration((Object)"PT1H");
    private final Duration flushDuration;
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ExecutorService queryExecutorService;
    private final IndexMerger indexMerger;
    private final IndexMergerV9 indexMergerV9;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final ObjectMapper objectMapper;

    @JsonCreator
    public FlushingPlumberSchool(@JsonProperty(value="flushDuration") Duration flushDuration, @JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject @Processing ExecutorService queryExecutorService, @JacksonInject IndexMerger indexMerger, @JacksonInject IndexMergerV9 indexMergerV9, @JacksonInject IndexIO indexIO, @JacksonInject Cache cache, @JacksonInject CacheConfig cacheConfig, @JacksonInject ObjectMapper objectMapper) {
        super(emitter, conglomerate, null, segmentAnnouncer, null, null, queryExecutorService, indexMerger, indexMergerV9, indexIO, cache, cacheConfig, objectMapper);
        this.flushDuration = flushDuration == null ? defaultFlushDuration : flushDuration;
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryExecutorService = queryExecutorService;
        this.indexMerger = (IndexMerger)Preconditions.checkNotNull((Object)indexMerger, (Object)"Null IndexMerger");
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.objectMapper = objectMapper;
    }

    @Override
    public Plumber findPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        this.verifyState();
        return new FlushingPlumber(this.flushDuration, schema, config, metrics, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryExecutorService, (IndexMerger)(config.getBuildV9Directly() != false ? this.indexMergerV9 : this.indexMerger), this.indexIO, this.cache, this.cacheConfig, this.objectMapper);
    }

    private void verifyState() {
        Preconditions.checkNotNull((Object)this.conglomerate, (Object)"must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull((Object)this.segmentAnnouncer, (Object)"must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull((Object)this.emitter, (Object)"must specify a serviceEmitter to do this action.");
    }
}

