/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.ircclouds.irc.api.domain.messages.ChannelPrivMsg;
import com.metamx.common.Pair;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.segment.realtime.firehose.IrcDecoder;
import org.joda.time.DateTime;

@JsonTypeName(value="irc")
public class IrcInputRowParser
implements InputRowParser<Pair<DateTime, ChannelPrivMsg>> {
    private final ParseSpec parseSpec;
    private final IrcDecoder decoder;

    @JsonCreator
    public IrcInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="decoder") IrcDecoder decoder) {
        this.parseSpec = parseSpec;
        this.decoder = decoder;
    }

    @JsonProperty
    public IrcDecoder getDecoder() {
        return this.decoder;
    }

    public InputRow parse(Pair<DateTime, ChannelPrivMsg> msg) {
        return this.decoder.decodeMessage((DateTime)msg.lhs, ((ChannelPrivMsg)msg.rhs).getChannelName(), ((ChannelPrivMsg)msg.rhs).getText());
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new IrcInputRowParser(parseSpec, this.decoder);
    }
}

