/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import io.druid.data.input.Firehose;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import io.druid.segment.realtime.firehose.WindowedStorageAdapter;
import io.druid.utils.Runnables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class IngestSegmentFirehose
implements Firehose {
    private volatile Yielder<InputRow> rowYielder;

    public IngestSegmentFirehose(List<WindowedStorageAdapter> adapters, final List<String> dims, final List<String> metrics, final DimFilter dimFilter, final QueryGranularity granularity) {
        Sequence rows = Sequences.concat((Iterable)Iterables.transform(adapters, (Function)new Function<WindowedStorageAdapter, Sequence<InputRow>>(){

            @Nullable
            public Sequence<InputRow> apply(WindowedStorageAdapter adapter) {
                return Sequences.concat((Sequence)Sequences.map((Sequence)adapter.getAdapter().makeCursors(Filters.toFilter((DimFilter)dimFilter), adapter.getInterval(), granularity, false), (Function)new Function<Cursor, Sequence<InputRow>>(){

                    @Nullable
                    public Sequence<InputRow> apply(final Cursor cursor) {
                        final LongColumnSelector timestampColumnSelector = cursor.makeLongColumnSelector("__time");
                        final HashMap dimSelectors = Maps.newHashMap();
                        for (String dim : dims) {
                            DimensionSelector dimSelector = cursor.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(dim, dim));
                            if (dimSelector == null) continue;
                            dimSelectors.put(dim, dimSelector);
                        }
                        final HashMap metSelectors = Maps.newHashMap();
                        for (String metric : metrics) {
                            ObjectColumnSelector metricSelector = cursor.makeObjectColumnSelector(metric);
                            if (metricSelector == null) continue;
                            metSelectors.put(metric, metricSelector);
                        }
                        return Sequences.simple((Iterable)new Iterable<InputRow>(){

                            @Override
                            public Iterator<InputRow> iterator() {
                                return new Iterator<InputRow>(){

                                    @Override
                                    public boolean hasNext() {
                                        return !cursor.isDone();
                                    }

                                    @Override
                                    public InputRow next() {
                                        DimensionSelector selector;
                                        LinkedHashMap theEvent = Maps.newLinkedHashMap();
                                        long timestamp = timestampColumnSelector.get();
                                        theEvent.put("timestamp", new DateTime(timestamp));
                                        for (Map.Entry dimSelector : dimSelectors.entrySet()) {
                                            String dim = (String)dimSelector.getKey();
                                            selector = (DimensionSelector)dimSelector.getValue();
                                            IndexedInts vals = selector.getRow();
                                            if (vals.size() == 1) {
                                                String dimVal = selector.lookupName(vals.get(0));
                                                theEvent.put(dim, dimVal);
                                                continue;
                                            }
                                            ArrayList dimVals = Lists.newArrayList();
                                            for (int i = 0; i < vals.size(); ++i) {
                                                dimVals.add(selector.lookupName(vals.get(i)));
                                            }
                                            theEvent.put(dim, dimVals);
                                        }
                                        for (Map.Entry metSelector : metSelectors.entrySet()) {
                                            String metric = (String)metSelector.getKey();
                                            selector = (ObjectColumnSelector)metSelector.getValue();
                                            theEvent.put(metric, selector.get());
                                        }
                                        cursor.advance();
                                        return new MapBasedInputRow(timestamp, dims, (Map)theEvent);
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UnsupportedOperationException("Remove Not Supported");
                                    }
                                };
                            }
                        });
                    }
                }));
            }
        }));
        this.rowYielder = rows.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<InputRow, InputRow>(){

            public InputRow accumulate(InputRow accumulated, InputRow in) {
                this.yield();
                return in;
            }
        });
    }

    public boolean hasMore() {
        return !this.rowYielder.isDone();
    }

    public InputRow nextRow() {
        InputRow inputRow = (InputRow)this.rowYielder.get();
        this.rowYielder = this.rowYielder.next(null);
        return inputRow;
    }

    public Runnable commit() {
        return Runnables.getNoopRunnable();
    }

    public void close() throws IOException {
        this.rowYielder.close();
    }
}

