/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.guice.annotations.Json;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.loading.DataSegmentPusherUtil;
import io.druid.segment.loading.LoadSpec;
import io.druid.segment.loading.QueryableIndexFactory;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.loading.StorageLocation;
import io.druid.segment.loading.StorageLocationConfig;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class SegmentLoaderLocalCacheManager
implements SegmentLoader {
    private static final Logger log = new Logger(SegmentLoaderLocalCacheManager.class);
    private final QueryableIndexFactory factory;
    private final SegmentLoaderConfig config;
    private final ObjectMapper jsonMapper;
    private final List<StorageLocation> locations;
    private final Object lock = new Object();

    @Inject
    public SegmentLoaderLocalCacheManager(QueryableIndexFactory factory, SegmentLoaderConfig config, @Json ObjectMapper mapper) {
        this.factory = factory;
        this.config = config;
        this.jsonMapper = mapper;
        this.locations = Lists.newArrayList();
        for (StorageLocationConfig locationConfig : config.getLocations()) {
            this.locations.add(new StorageLocation(locationConfig.getPath(), locationConfig.getMaxSize()));
        }
    }

    public SegmentLoaderLocalCacheManager withConfig(SegmentLoaderConfig config) {
        return new SegmentLoaderLocalCacheManager(this.factory, config, this.jsonMapper);
    }

    @Override
    public boolean isSegmentLoaded(DataSegment segment) {
        return this.findStorageLocationIfLoaded(segment) != null;
    }

    public StorageLocation findStorageLocationIfLoaded(DataSegment segment) {
        for (StorageLocation location : this.locations) {
            File localStorageDir = new File(location.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
            if (!localStorageDir.exists()) continue;
            return location;
        }
        return null;
    }

    @Override
    public Segment getSegment(DataSegment segment) throws SegmentLoadingException {
        File segmentFiles = this.getSegmentFiles(segment);
        QueryableIndex index = this.factory.factorize(segmentFiles);
        return new QueryableIndexSegment(segment.getIdentifier(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getSegmentFiles(DataSegment segment) throws SegmentLoadingException {
        File retVal;
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        if (loc == null) {
            Iterator<StorageLocation> locIter = this.locations.iterator();
            loc = locIter.next();
            while (locIter.hasNext()) {
                loc = loc.mostEmpty(locIter.next());
            }
            if (!loc.canHandle(segment.getSize())) {
                throw new ISE("Segment[%s:%,d] too large for storage[%s:%,d].", new Object[]{segment.getIdentifier(), segment.getSize(), loc.getPath(), loc.available()});
            }
            File storageDir = new File(loc.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
            File downloadStartMarker = new File(storageDir, "downloadStartMarker");
            Object object = this.lock;
            synchronized (object) {
                if (!storageDir.mkdirs()) {
                    log.debug("Unable to make parent file[%s]", new Object[]{storageDir});
                }
                try {
                    if (!downloadStartMarker.createNewFile()) {
                        throw new SegmentLoadingException("Was not able to create new download marker for [%s]", new Object[]{storageDir});
                    }
                }
                catch (IOException e) {
                    throw new SegmentLoadingException((Throwable)e, "Unable to create marker file for [%s]", new Object[]{storageDir});
                }
            }
            LoadSpec loadSpec = (LoadSpec)this.jsonMapper.convertValue((Object)segment.getLoadSpec(), LoadSpec.class);
            LoadSpec.LoadSpecResult result = loadSpec.loadSegment(storageDir);
            if (result.getSize() != segment.getSize()) {
                log.warn("Segment [%s] is different than expected size. Expected [%d] found [%d]", new Object[]{segment.getIdentifier(), segment.getSize(), result.getSize()});
            }
            if (!downloadStartMarker.delete()) {
                throw new SegmentLoadingException("Unable to remove marker file for [%s]", new Object[]{storageDir});
            }
            retVal = storageDir;
        } else {
            retVal = new File(loc.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
        }
        loc.addSegment(segment);
        return retVal;
    }

    @Override
    public void cleanup(DataSegment segment) throws SegmentLoadingException {
        if (!this.config.isDeleteOnRemove()) {
            return;
        }
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        if (loc == null) {
            log.info("Asked to cleanup something[%s] that didn't exist.  Skipping.", new Object[]{segment});
            return;
        }
        try {
            File cacheFile = new File(loc.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
            this.cleanupCacheFiles(loc.getPath(), cacheFile);
            loc.removeSegment(segment);
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupCacheFiles(File baseFile, File cacheFile) throws IOException {
        if (cacheFile.equals(baseFile)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            log.info("Deleting directory[%s]", new Object[]{cacheFile});
            try {
                FileUtils.deleteDirectory((File)cacheFile);
            }
            catch (Exception e) {
                log.error("Unable to remove file[%s]", new Object[]{cacheFile});
            }
        }
        if (cacheFile.getParentFile() != null && cacheFile.getParentFile().listFiles().length == 0) {
            this.cleanupCacheFiles(baseFile, cacheFile.getParentFile());
        }
    }
}

