/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import io.druid.segment.loading.LoadSpec;
import io.druid.segment.loading.LocalDataSegmentPuller;
import io.druid.segment.loading.SegmentLoadingException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

@JsonTypeName(value="local")
public class LocalLoadSpec
implements LoadSpec {
    private final Path path;
    private final LocalDataSegmentPuller puller;

    @JsonCreator
    public LocalLoadSpec(@JacksonInject LocalDataSegmentPuller puller, @JsonProperty(value="path", required=true) String path) {
        Preconditions.checkNotNull((Object)path);
        this.path = Paths.get(path, new String[0]);
        Preconditions.checkArgument((boolean)Files.exists(Paths.get(path, new String[0]), new LinkOption[0]), (String)"[%s] does not exist", (Object[])new Object[]{path});
        this.puller = puller;
    }

    @JsonProperty
    public String getPath() {
        return this.path.toString();
    }

    public LoadSpec.LoadSpecResult loadSegment(File outDir) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.path.toFile(), outDir).size());
    }
}

