/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.initialization.DruidModule;
import io.druid.query.lookup.LookupConfig;
import io.druid.query.lookup.LookupIntrospectionResource;
import io.druid.query.lookup.LookupListeningAnnouncerConfig;
import io.druid.query.lookup.LookupListeningResource;
import io.druid.query.lookup.LookupReferencesManager;
import io.druid.query.lookup.LookupResourceListenerAnnouncer;
import io.druid.query.lookup.MapLookupExtractorFactory;
import io.druid.server.initialization.jetty.JettyBindings;
import java.util.List;
import org.apache.curator.utils.ZKPaths;

public class LookupModule
implements DruidModule {
    static final String PROPERTY_BASE = "druid.lookup";
    public static final String FAILED_UPDATES_KEY = "failedUpdates";

    public static String getTierListenerPath(String tier) {
        return ZKPaths.makePath((String)"lookups", (String)tier);
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new SimpleModule("DruidLookupModule").registerSubtypes(new Class[]{MapLookupExtractorFactory.class}));
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)PROPERTY_BASE, LookupConfig.class);
        LifecycleModule.register((Binder)binder, LookupReferencesManager.class);
        JsonConfigProvider.bind((Binder)binder, (String)PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        Jerseys.addResource((Binder)binder, LookupListeningResource.class);
        Jerseys.addResource((Binder)binder, LookupIntrospectionResource.class);
        LifecycleModule.register((Binder)binder, LookupResourceListenerAnnouncer.class);
        binder.bind(LookupResourceListenerAnnouncer.class).in(ManageLifecycle.class);
        JettyBindings.addQosFilter(binder, "/druid/listen/v1/lookups", 2);
    }
}

