/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.RE;
import com.metamx.common.logger.Logger;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.query.lookup.LookupExtractorFactory;
import io.druid.query.lookup.LookupReferencesManager;
import io.druid.server.listener.resource.AbstractListenerHandler;
import io.druid.server.listener.resource.ListenerResource;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;

@Path(value="/druid/listen/v1/lookups")
class LookupListeningResource
extends ListenerResource {
    private static final Logger LOG = new Logger(LookupListeningResource.class);

    @Inject
    public LookupListeningResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, final LookupReferencesManager manager) {
        super(jsonMapper, smileMapper, new AbstractListenerHandler<LookupExtractorFactory>((TypeReference)new TypeReference<LookupExtractorFactory>(){}){

            @Override
            public Object post(Map<String, LookupExtractorFactory> lookups) throws Exception {
                HashMap<String, LookupExtractorFactory> failedUpdates = new HashMap<String, LookupExtractorFactory>();
                for (String name : lookups.keySet()) {
                    LookupExtractorFactory factory = lookups.get(name);
                    try {
                        if (manager.updateIfNew(name, factory) || !factory.replaces(manager.get(name))) continue;
                        failedUpdates.put(name, factory);
                    }
                    catch (ISE ise) {
                        LOG.error((Throwable)ise, "Error starting [%s]: [%s]", new Object[]{name, factory});
                        failedUpdates.put(name, factory);
                    }
                }
                return ImmutableMap.of((Object)"status", (Object)"accepted", (Object)"failedUpdates", failedUpdates);
            }

            @Override
            public Object get(String id) {
                return manager.get(id);
            }

            @Override
            public Map<String, LookupExtractorFactory> getAll() {
                return manager.getAll();
            }

            @Override
            public Object delete(String id) {
                if (manager.get(id) == null) {
                    return null;
                }
                if (!manager.remove(id)) {
                    if (manager.get(id) == null) {
                        return null;
                    }
                    throw new RE("Could not remove lookup [%s]", new Object[]{id});
                }
                return id;
            }
        });
    }
}

