/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.Pair;
import com.metamx.common.StringUtils;
import com.metamx.emitter.EmittingLogger;
import io.druid.metadata.EntryExistsException;
import io.druid.metadata.MetadataStorageActionHandler;
import io.druid.metadata.MetadataStorageActionHandlerTypes;
import io.druid.metadata.SQLMetadataConnector;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

public class SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
implements MetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataStorageActionHandler.class);
    private final SQLMetadataConnector connector;
    private final ObjectMapper jsonMapper;
    private final TypeReference entryType;
    private final TypeReference statusType;
    private final TypeReference logType;
    private final TypeReference lockType;
    private final String entryTypeName;
    private final String entryTable;
    private final String logTable;
    private final String lockTable;

    public SQLMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        this.connector = connector;
        this.jsonMapper = jsonMapper;
        this.entryType = types.getEntryType();
        this.statusType = types.getStatusType();
        this.logType = types.getLogType();
        this.lockType = types.getLockType();
        this.entryTypeName = entryTypeName;
        this.entryTable = entryTable;
        this.logTable = logTable;
        this.lockTable = lockTable;
    }

    public void insert(final String id, final DateTime timestamp, final String dataSource, final EntryType entry, final boolean active, final StatusType status) throws EntryExistsException {
        try {
            this.connector.retryWithHandle(new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (id, created_date, datasource, payload, active, status_payload) VALUES (:id, :created_date, :datasource, :payload, :active, :status_payload)", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", id)).bind("created_date", timestamp.toString())).bind("datasource", dataSource)).bind("payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(entry))).bind("active", active)).bind("status_payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(status))).execute();
                    return null;
                }
            }, new Predicate<Throwable>(){

                public boolean apply(Throwable e) {
                    boolean isStatementException = e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
                    return SQLMetadataStorageActionHandler.this.connector.isTransientException(e) && (!isStatementException || !SQLMetadataStorageActionHandler.this.getEntry(id).isPresent());
                }
            });
        }
        catch (Exception e) {
            boolean isStatementException;
            boolean bl = isStatementException = e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
            if (isStatementException && this.getEntry(id).isPresent()) {
                throw new EntryExistsException(id, (Throwable)e);
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean setStatus(final String entryId, final boolean active, final StatusType status) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)((Update)handle.createStatement(String.format("UPDATE %s SET active = :active, status_payload = :status_payload WHERE id = :id AND active = TRUE", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).bind("active", active)).bind("status_payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(status))).execute() == 1;
            }
        });
    }

    public Optional<EntryType> getEntry(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<EntryType>>(){

            public Optional<EntryType> withHandle(Handle handle) throws Exception {
                byte[] res = (byte[])((Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE id = :id", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.entryType));
            }
        });
    }

    public Optional<StatusType> getStatus(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<StatusType>>(){

            public Optional<StatusType> withHandle(Handle handle) throws Exception {
                byte[] res = (byte[])((Query)handle.createQuery(String.format("SELECT status_payload FROM %s WHERE id = :id", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.statusType));
            }
        });
    }

    public List<Pair<EntryType, StatusType>> getActiveEntriesWithStatus() {
        return (List)this.connector.retryWithHandle(new HandleCallback<List<Pair<EntryType, StatusType>>>(){

            public List<Pair<EntryType, StatusType>> withHandle(Handle handle) throws Exception {
                return handle.createQuery(String.format("SELECT id, payload, status_payload FROM %s WHERE active = TRUE ORDER BY created_date", SQLMetadataStorageActionHandler.this.entryTable)).map(new ResultSetMapper<Pair<EntryType, StatusType>>(){

                    public Pair<EntryType, StatusType> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of((Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("payload"), SQLMetadataStorageActionHandler.this.entryType), (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("status_payload"), SQLMetadataStorageActionHandler.this.statusType));
                        }
                        catch (IOException e) {
                            log.makeAlert((Throwable)e, "Failed to parse entry payload", new Object[0]).addData("entry", (Object)r.getString("id")).emit();
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }

    public List<StatusType> getInactiveStatusesSince(final DateTime timestamp) {
        return (List)this.connector.retryWithHandle(new HandleCallback<List<StatusType>>(){

            public List<StatusType> withHandle(Handle handle) throws Exception {
                return ((Query)handle.createQuery(String.format("SELECT id, status_payload FROM %s WHERE active = FALSE AND created_date >= :start ORDER BY created_date DESC", SQLMetadataStorageActionHandler.this.entryTable)).bind("start", timestamp.toString())).map(new ResultSetMapper<StatusType>(){

                    public StatusType map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("status_payload"), SQLMetadataStorageActionHandler.this.statusType);
                        }
                        catch (IOException e) {
                            log.makeAlert((Throwable)e, "Failed to parse status payload", new Object[0]).addData("entry", (Object)r.getString("id")).emit();
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }

    public boolean addLock(final String entryId, final LockType lock) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s_id, lock_payload) VALUES (:entryId, :payload)", SQLMetadataStorageActionHandler.this.lockTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).bind("payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(lock))).execute() == 1;
            }
        });
    }

    public void removeLock(final long lockId) {
        this.connector.retryWithHandle(new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                ((Update)handle.createStatement(String.format("DELETE FROM %s WHERE id = :id", SQLMetadataStorageActionHandler.this.lockTable)).bind("id", lockId)).execute();
                return null;
            }
        });
    }

    public boolean addLog(final String entryId, final LogType log) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s_id, log_payload) VALUES (:entryId, :payload)", SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).bind("payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(log))).execute() == 1;
            }
        });
    }

    public List<LogType> getLogs(final String entryId) {
        return (List)this.connector.retryWithHandle(new HandleCallback<List<LogType>>(){

            public List<LogType> withHandle(Handle handle) throws Exception {
                return (List)((Query)handle.createQuery(String.format("SELECT log_payload FROM %1$s WHERE %2$s_id = :entryId", SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).fold((Object)Lists.newLinkedList(), new Folder3<List<LogType>, byte[]>(){

                    public List<LogType> fold(List<LogType> list, byte[] bytes, FoldController control, StatementContext ctx) throws SQLException {
                        try {
                            list.add(SQLMetadataStorageActionHandler.this.jsonMapper.readValue(bytes, SQLMetadataStorageActionHandler.this.logType));
                            return list;
                        }
                        catch (IOException e) {
                            log.makeAlert((Throwable)e, "Failed to deserialize log", new Object[0]).addData("entryId", (Object)entryId).addData("payload", (Object)StringUtils.fromUtf8((byte[])bytes)).emit();
                            throw new SQLException(e);
                        }
                    }
                });
            }
        });
    }

    public Map<Long, LockType> getLocks(final String entryId) {
        return (Map)this.connector.retryWithHandle(new HandleCallback<Map<Long, LockType>>(){

            public Map<Long, LockType> withHandle(Handle handle) throws Exception {
                return (Map)((Query)handle.createQuery(String.format("SELECT id, lock_payload FROM %1$s WHERE %2$s_id = :entryId", SQLMetadataStorageActionHandler.this.lockTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).map(new ResultSetMapper<Pair<Long, LockType>>(){

                    public Pair<Long, LockType> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of((Object)r.getLong("id"), (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("lock_payload"), SQLMetadataStorageActionHandler.this.lockType));
                        }
                        catch (IOException e) {
                            log.makeAlert((Throwable)e, "Failed to deserialize " + SQLMetadataStorageActionHandler.this.lockType.getType(), new Object[0]).addData("id", (Object)r.getLong("id")).addData("lockPayload", (Object)StringUtils.fromUtf8((byte[])r.getBytes("lock_payload"))).emit();
                            throw new SQLException(e);
                        }
                    }
                }).fold((Object)Maps.newLinkedHashMap(), new Folder3<Map<Long, LockType>, Pair<Long, LockType>>(){

                    public Map<Long, LockType> fold(Map<Long, LockType> accumulator, Pair<Long, LockType> lock, FoldController control, StatementContext ctx) throws SQLException {
                        accumulator.put((Long)lock.lhs, lock.rhs);
                        return accumulator;
                    }
                });
            }
        });
    }
}

