/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.audit.AuditEntry;
import io.druid.audit.AuditInfo;
import io.druid.audit.AuditManager;
import io.druid.concurrent.Execs;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Json;
import io.druid.metadata.MetadataRuleManager;
import io.druid.metadata.MetadataRuleManagerConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.server.coordinator.rules.ForeverLoadRule;
import io.druid.server.coordinator.rules.Rule;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@ManageLifecycle
public class SQLMetadataRuleManager
implements MetadataRuleManager {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataRuleManager.class);
    private final ObjectMapper jsonMapper;
    private final Supplier<MetadataRuleManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final IDBI dbi;
    private final AtomicReference<ImmutableMap<String, List<Rule>>> rules;
    private final AuditManager auditManager;
    private final Object lock = new Object();
    private volatile boolean started = false;
    private volatile ListeningScheduledExecutorService exec = null;
    private volatile ListenableFuture<?> future = null;
    private volatile long retryStartTime = 0L;

    public static void createDefaultRule(IDBI dbi, final String ruleTable, final String defaultDatasourceName, final ObjectMapper jsonMapper) {
        try {
            dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    List existing = ((Query)handle.createQuery(String.format("SELECT id from %s where datasource=:dataSource", ruleTable)).bind("dataSource", defaultDatasourceName)).list();
                    if (!existing.isEmpty()) {
                        return null;
                    }
                    List<Rule> defaultRules = Arrays.asList(new ForeverLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"_default_tier", (Object)2)));
                    String version = new DateTime().toString();
                    ((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (id, dataSource, version, payload) VALUES (:id, :dataSource, :version, :payload)", ruleTable)).bind("id", String.format("%s_%s", defaultDatasourceName, version))).bind("dataSource", defaultDatasourceName)).bind("version", version)).bind("payload", jsonMapper.writeValueAsBytes(defaultRules))).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Inject
    public SQLMetadataRuleManager(@Json ObjectMapper jsonMapper, Supplier<MetadataRuleManagerConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, SQLMetadataConnector connector, AuditManager auditManager) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dbi = connector.getDBI();
        this.auditManager = auditManager;
        this.rules = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.exec = MoreExecutors.listeningDecorator((ScheduledExecutorService)Execs.scheduledSingleThreaded((String)"DatabaseRuleManager-Exec--%d"));
            SQLMetadataRuleManager.createDefaultRule(this.dbi, this.getRulesTable(), ((MetadataRuleManagerConfig)this.config.get()).getDefaultRule(), this.jsonMapper);
            this.future = this.exec.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLMetadataRuleManager.this.poll();
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "uncaught exception in rule manager polling thread", new Object[0]);
                    }
                }
            }, 0L, ((MetadataRuleManagerConfig)this.config.get()).getPollDuration().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.rules.set((ImmutableMap<String, List<Rule>>)ImmutableMap.of());
            this.future.cancel(false);
            this.future = null;
            this.started = false;
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    @Override
    public void poll() {
        try {
            ImmutableMap newRules = ImmutableMap.copyOf((Map)((Map)this.dbi.withHandle((HandleCallback)new HandleCallback<Map<String, List<Rule>>>(){

                public Map<String, List<Rule>> withHandle(Handle handle) throws Exception {
                    return (Map)handle.createQuery(String.format("SELECT r.dataSource, r.payload FROM %1$s r INNER JOIN(SELECT dataSource, max(version) as version FROM %1$s GROUP BY dataSource) ds ON r.datasource = ds.datasource and r.version = ds.version", SQLMetadataRuleManager.this.getRulesTable())).map((ResultSetMapper)new ResultSetMapper<Pair<String, List<Rule>>>(){

                        public Pair<String, List<Rule>> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                            try {
                                return Pair.of((Object)r.getString("dataSource"), (Object)SQLMetadataRuleManager.this.jsonMapper.readValue(r.getBytes("payload"), (TypeReference)new TypeReference<List<Rule>>(){}));
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    }).fold((Object)Maps.newHashMap(), (Folder3)new Folder3<Map<String, List<Rule>>, Pair<String, List<Rule>>>(){

                        public Map<String, List<Rule>> fold(Map<String, List<Rule>> retVal, Pair<String, List<Rule>> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                            try {
                                String dataSource = (String)stringObjectMap.lhs;
                                retVal.put(dataSource, (List<Rule>)stringObjectMap.rhs);
                                return retVal;
                            }
                            catch (Exception e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    });
                }
            })));
            log.info("Polled and found rules for %,d datasource(s)", new Object[]{newRules.size()});
            this.rules.set((ImmutableMap<String, List<Rule>>)newRules);
            this.retryStartTime = 0L;
        }
        catch (Exception e) {
            if (this.retryStartTime == 0L) {
                this.retryStartTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.retryStartTime > (long)((MetadataRuleManagerConfig)this.config.get()).getAlertThreshold().getMillis()) {
                log.makeAlert((Throwable)e, "Exception while polling for rules", new Object[0]).emit();
                this.retryStartTime = 0L;
            }
            log.error((Throwable)e, "Exception while polling for rules", new Object[0]);
        }
    }

    @Override
    public Map<String, List<Rule>> getAllRules() {
        return (Map)this.rules.get();
    }

    @Override
    public List<Rule> getRules(String dataSource) {
        List retVal = (List)this.rules.get().get((Object)dataSource);
        return retVal == null ? Lists.newArrayList() : retVal;
    }

    @Override
    public List<Rule> getRulesWithDefault(String dataSource) {
        ArrayList retVal = Lists.newArrayList();
        Map theRules = (Map)this.rules.get();
        if (theRules.get(dataSource) != null) {
            retVal.addAll((Collection)theRules.get(dataSource));
        }
        if (theRules.get(((MetadataRuleManagerConfig)this.config.get()).getDefaultRule()) != null) {
            retVal.addAll((Collection)theRules.get(((MetadataRuleManagerConfig)this.config.get()).getDefaultRule()));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean overrideRule(final String dataSource, final List<Rule> newRules, final AuditInfo auditInfo) {
        String ruleString;
        try {
            ruleString = this.jsonMapper.writeValueAsString(newRules);
            log.info("Updating [%s] with rules [%s] as per [%s]", new Object[]{dataSource, ruleString, auditInfo});
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Unable to write rules as string for [%s]", new Object[]{dataSource});
            return false;
        }
        Object e = this.lock;
        synchronized (e) {
            try {
                this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

                    public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                        DateTime auditTime = DateTime.now();
                        SQLMetadataRuleManager.this.auditManager.doAudit(AuditEntry.builder().key(dataSource).type("rules").auditInfo(auditInfo).payload(ruleString).auditTime(auditTime).build(), handle);
                        String version = auditTime.toString();
                        ((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (id, dataSource, version, payload) VALUES (:id, :dataSource, :version, :payload)", SQLMetadataRuleManager.this.getRulesTable())).bind("id", String.format("%s_%s", dataSource, version))).bind("dataSource", dataSource)).bind("version", version)).bind("payload", SQLMetadataRuleManager.this.jsonMapper.writeValueAsBytes((Object)newRules))).execute();
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                log.error((Throwable)e2, String.format("Exception while overriding rule for %s", dataSource), new Object[0]);
                return false;
            }
        }
        try {
            this.poll();
        }
        catch (Exception e2) {
            log.error((Throwable)e2, String.format("Exception while polling for rules after overriding the rule for %s", dataSource), new Object[0]);
        }
        return true;
    }

    private String getRulesTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getRulesTable();
    }
}

