/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice.http;

import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.HttpClientConfig;
import com.metamx.http.client.HttpClientInit;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Global;
import io.druid.guice.http.AbstractHttpClientProvider;
import io.druid.guice.http.DruidHttpClientConfig;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;

public class HttpClientModule
implements Module {
    private final String propertyPrefix;
    private Annotation annotation = null;
    private Class<? extends Annotation> annotationClazz = null;

    public static HttpClientModule global() {
        return new HttpClientModule("druid.global.http", Global.class);
    }

    public HttpClientModule(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public HttpClientModule(String propertyPrefix, Class<? extends Annotation> annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotationClazz = annotation;
    }

    public HttpClientModule(String propertyPrefix, Annotation annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotation = annotation;
    }

    public void configure(Binder binder) {
        if (this.annotation != null) {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, (Annotation)this.annotation);
            binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.annotation)).in(LazySingleton.class);
        } else if (this.annotationClazz != null) {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, this.annotationClazz);
            binder.bind(HttpClient.class).annotatedWith(this.annotationClazz).toProvider((Provider)new HttpClientProvider(this.annotationClazz)).in(LazySingleton.class);
        } else {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class);
            binder.bind(HttpClient.class).toProvider((Provider)new HttpClientProvider()).in(LazySingleton.class);
        }
    }

    public static class HttpClientProvider
    extends AbstractHttpClientProvider<HttpClient> {
        public HttpClientProvider() {
        }

        public HttpClientProvider(Annotation annotation) {
            super(annotation);
        }

        public HttpClientProvider(Class<? extends Annotation> annotationClazz) {
            super(annotationClazz);
        }

        public HttpClient get() {
            DruidHttpClientConfig config = (DruidHttpClientConfig)((Supplier)this.getConfigProvider().get()).get();
            HttpClientConfig.Builder builder = HttpClientConfig.builder().withNumConnections(config.getNumConnections()).withReadTimeout(config.getReadTimeout());
            if (this.getSslContextBinding() != null) {
                builder.withSslContext((SSLContext)this.getSslContextBinding().getProvider().get());
            }
            return HttpClientInit.createClient((HttpClientConfig)builder.build(), (Lifecycle)((Lifecycle)this.getLifecycleProvider().get()));
        }
    }
}

