/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator.discovery;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.net.HostAndPort;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.client.selector.DiscoverySelector;
import io.druid.client.selector.Server;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;

public class ServerDiscoverySelector
implements DiscoverySelector<Server> {
    private static final Logger log = new Logger(ServerDiscoverySelector.class);
    private final ServiceProvider serviceProvider;
    private static final Function<ServiceInstance, Server> TO_SERVER = new Function<ServiceInstance, Server>(){

        public Server apply(final ServiceInstance instance) {
            return new Server(){

                @Override
                public String getHost() {
                    return HostAndPort.fromParts((String)this.getAddress(), (int)this.getPort()).toString();
                }

                @Override
                public String getAddress() {
                    return instance.getAddress();
                }

                @Override
                public int getPort() {
                    return instance.getPort();
                }

                @Override
                public String getScheme() {
                    return "http";
                }
            };
        }
    };

    public ServerDiscoverySelector(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public Server pick() {
        ServiceInstance instance;
        try {
            instance = this.serviceProvider.getInstance();
        }
        catch (Exception e) {
            log.info((Throwable)e, "Exception getting instance", new Object[0]);
            return null;
        }
        if (instance == null) {
            log.error("No server instance found", new Object[0]);
            return null;
        }
        return (Server)TO_SERVER.apply((Object)instance);
    }

    public Collection<Server> getAll() {
        try {
            return Collections2.transform((Collection)this.serviceProvider.getAllInstances(), TO_SERVER);
        }
        catch (Exception e) {
            log.info((Throwable)e, "Unable to get all instances", new Object[0]);
            return Collections.emptyList();
        }
    }

    @LifecycleStart
    public void start() throws Exception {
        this.serviceProvider.start();
    }

    @LifecycleStop
    public void stop() throws IOException {
        this.serviceProvider.close();
    }
}

