/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.selector;

import com.google.common.primitives.Ints;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelectorStrategy;
import io.druid.timeline.DataSegment;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class ConnectionCountServerSelectorStrategy
implements ServerSelectorStrategy {
    private static final Comparator<QueryableDruidServer> comparator = new Comparator<QueryableDruidServer>(){

        @Override
        public int compare(QueryableDruidServer left, QueryableDruidServer right) {
            return Ints.compare((int)left.getClient().getNumOpenConnections(), (int)right.getClient().getNumOpenConnections());
        }
    };

    @Override
    public QueryableDruidServer pick(Set<QueryableDruidServer> servers, DataSegment segment) {
        return Collections.min(servers, comparator);
    }
}

