/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.selector;

import com.metamx.common.ISE;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelectorStrategy;
import io.druid.client.selector.TierSelectorStrategy;
import io.druid.timeline.DataSegment;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractTierSelectorStrategy
implements TierSelectorStrategy {
    private final ServerSelectorStrategy serverSelectorStrategy;

    public AbstractTierSelectorStrategy(ServerSelectorStrategy serverSelectorStrategy) {
        this.serverSelectorStrategy = serverSelectorStrategy;
    }

    @Override
    public QueryableDruidServer pick(TreeMap<Integer, Set<QueryableDruidServer>> prioritizedServers, DataSegment segment) {
        Map.Entry<Integer, Set<QueryableDruidServer>> priorityServers = prioritizedServers.pollFirstEntry();
        if (priorityServers == null) {
            return null;
        }
        Set<QueryableDruidServer> servers = priorityServers.getValue();
        switch (servers.size()) {
            case 0: {
                throw new ISE("[%s] Something hella weird going on here. We should not be here", new Object[]{segment.getIdentifier()});
            }
            case 1: {
                return priorityServers.getValue().iterator().next();
            }
        }
        return this.serverSelectorStrategy.pick(servers, segment);
    }
}

