/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.LazySequence;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.CacheUtil;
import io.druid.client.DruidServer;
import io.druid.client.ServerView;
import io.druid.client.TimelineServerView;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelector;
import io.druid.concurrent.Execs;
import io.druid.guice.annotations.BackgroundCaching;
import io.druid.guice.annotations.Smile;
import io.druid.query.BaseQuery;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.CacheStrategy;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.Result;
import io.druid.query.SegmentDescriptor;
import io.druid.query.aggregation.MetricManipulatorFns;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DimFilterUtils;
import io.druid.query.spec.MultipleSpecificSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineLookup;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.ShardSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;

public class CachingClusteredClient<T>
implements QueryRunner<T> {
    private static final EmittingLogger log = new EmittingLogger(CachingClusteredClient.class);
    private final QueryToolChestWarehouse warehouse;
    private final TimelineServerView serverView;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final ListeningExecutorService backgroundExecutorService;

    @Inject
    public CachingClusteredClient(QueryToolChestWarehouse warehouse, TimelineServerView serverView, Cache cache, @Smile ObjectMapper objectMapper, @BackgroundCaching ExecutorService backgroundExecutorService, CacheConfig cacheConfig) {
        this.warehouse = warehouse;
        this.serverView = serverView;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.backgroundExecutorService = MoreExecutors.listeningDecorator((ExecutorService)backgroundExecutorService);
        serverView.registerSegmentCallback(Execs.singleThreaded((String)"CCClient-ServerView-CB-%d"), new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CachingClusteredClient.this.cache.close(segment.getIdentifier());
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        TimelineLookup<String, ServerSelector> timeline;
        final QueryToolChest toolChest = this.warehouse.getToolChest(query);
        final CacheStrategy strategy = toolChest.getCacheStrategy(query);
        final TreeMap serverSegments = Maps.newTreeMap();
        final ArrayList cachedResults = Lists.newArrayList();
        final HashMap cachePopulatorMap = Maps.newHashMap();
        boolean useCache = BaseQuery.getContextUseCache(query, (boolean)true) && strategy != null && this.cacheConfig.isUseCache() && this.cacheConfig.isQueryCacheable(query);
        final boolean populateCache = BaseQuery.getContextPopulateCache(query, (boolean)true) && strategy != null && this.cacheConfig.isPopulateCache() && this.cacheConfig.isQueryCacheable(query);
        final boolean isBySegment = BaseQuery.getContextBySegment(query, (boolean)false);
        final ImmutableMap.Builder contextBuilder = new ImmutableMap.Builder();
        int priority = BaseQuery.getContextPriority(query, (int)0);
        contextBuilder.put((Object)"priority", (Object)priority);
        if (populateCache) {
            contextBuilder.put((Object)"populateCache", (Object)false);
            contextBuilder.put((Object)"bySegment", (Object)true);
        }
        if ((timeline = this.serverView.getTimeline(query.getDataSource())) == null) {
            return Sequences.empty();
        }
        LinkedHashSet segments = Sets.newLinkedHashSet();
        LinkedList serversLookup = Lists.newLinkedList();
        int uncoveredIntervalsLimit = BaseQuery.getContextUncoveredIntervalsLimit(query, (int)0);
        if (uncoveredIntervalsLimit > 0) {
            ArrayList uncoveredIntervals = Lists.newArrayListWithCapacity((int)uncoveredIntervalsLimit);
            boolean uncoveredIntervalsOverflowed = false;
            for (Interval interval : query.getIntervals()) {
                Iterable lookup = timeline.lookup(interval);
                long startMillis = interval.getStartMillis();
                long endMillis = interval.getEndMillis();
                for (TimelineObjectHolder holder : lookup) {
                    Interval holderInterval = holder.getInterval();
                    long intervalStart = holderInterval.getStartMillis();
                    if (!uncoveredIntervalsOverflowed && startMillis != intervalStart) {
                        if (uncoveredIntervalsLimit > uncoveredIntervals.size()) {
                            uncoveredIntervals.add(new Interval(startMillis, intervalStart));
                        } else {
                            uncoveredIntervalsOverflowed = true;
                        }
                    }
                    startMillis = holderInterval.getEndMillis();
                    serversLookup.add(holder);
                }
                if (uncoveredIntervalsOverflowed || startMillis >= endMillis) continue;
                if (uncoveredIntervalsLimit > uncoveredIntervals.size()) {
                    uncoveredIntervals.add(new Interval(startMillis, endMillis));
                    continue;
                }
                uncoveredIntervalsOverflowed = true;
            }
            if (!uncoveredIntervals.isEmpty()) {
                responseContext.put("uncoveredIntervals", uncoveredIntervals);
                responseContext.put("uncoveredIntervalsOverflowed", uncoveredIntervalsOverflowed);
            }
        } else {
            for (Interval interval : query.getIntervals()) {
                Iterables.addAll((Collection)serversLookup, (Iterable)timeline.lookup(interval));
            }
        }
        List filteredServersLookup = toolChest.filterSegments(query, (List)serversLookup);
        HashMap dimensionRangeCache = Maps.newHashMap();
        for (TimelineObjectHolder holder : filteredServersLookup) {
            Set filteredChunks = DimFilterUtils.filterShards((DimFilter)query.getFilter(), (Iterable)holder.getObject(), (Function)new Function<PartitionChunk<ServerSelector>, ShardSpec>(){

                public ShardSpec apply(PartitionChunk<ServerSelector> input) {
                    return ((ServerSelector)input.getObject()).getSegment().getShardSpec();
                }
            }, (Map)dimensionRangeCache);
            Iterator startMillis = filteredChunks.iterator();
            while (startMillis.hasNext()) {
                PartitionChunk chunk = (PartitionChunk)startMillis.next();
                ServerSelector selector = (ServerSelector)chunk.getObject();
                SegmentDescriptor descriptor = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                segments.add(Pair.of((Object)selector, (Object)descriptor));
            }
        }
        byte[] queryCacheKey = (populateCache || useCache) && !isBySegment ? strategy.computeCacheKey(query) : null;
        if (queryCacheKey != null) {
            LinkedHashMap cacheKeys = Maps.newLinkedHashMap();
            for (Pair segment : segments) {
                Cache.NamedKey segmentCacheKey = CacheUtil.computeSegmentCacheKey(((ServerSelector)segment.lhs).getSegment().getIdentifier(), (SegmentDescriptor)segment.rhs, queryCacheKey);
                cacheKeys.put(segment, segmentCacheKey);
            }
            Map<Cache.NamedKey, Object> cachedValues = useCache ? this.cache.getBulk(Iterables.limit(cacheKeys.values(), (int)this.cacheConfig.getCacheBulkMergeLimit())) : ImmutableMap.of();
            for (Map.Entry entry : cacheKeys.entrySet()) {
                Pair segment = (Pair)entry.getKey();
                Cache.NamedKey segmentCacheKey = (Cache.NamedKey)entry.getValue();
                Interval segmentQueryInterval = ((SegmentDescriptor)segment.rhs).getInterval();
                byte[] cachedValue = (byte[])cachedValues.get(segmentCacheKey);
                if (cachedValue != null) {
                    segments.remove(segment);
                    cachedResults.add(Pair.of((Object)segmentQueryInterval, (Object)cachedValue));
                    continue;
                }
                if (!populateCache) continue;
                String segmentIdentifier = ((ServerSelector)segment.lhs).getSegment().getIdentifier();
                cachePopulatorMap.put(String.format("%s_%s", segmentIdentifier, segmentQueryInterval), new CachePopulator(this.cache, this.objectMapper, segmentCacheKey));
            }
        }
        for (Pair segment : segments) {
            QueryableDruidServer queryableDruidServer = ((ServerSelector)segment.lhs).pick();
            if (queryableDruidServer == null) {
                log.makeAlert("No servers found for SegmentDescriptor[%s] for DataSource[%s]?! How can this be?!", new Object[]{segment.rhs, query.getDataSource()}).emit();
                continue;
            }
            DruidServer server = queryableDruidServer.getServer();
            List descriptors = (List)serverSegments.get(server);
            if (descriptors == null) {
                descriptors = Lists.newArrayList();
                serverSegments.put(server, descriptors);
            }
            descriptors.add(segment.rhs);
        }
        return new LazySequence(new Supplier<Sequence<T>>(){

            public Sequence<T> get() {
                ArrayList sequencesByInterval = Lists.newArrayList();
                this.addSequencesFromCache(sequencesByInterval);
                this.addSequencesFromServer(sequencesByInterval);
                return CachingClusteredClient.this.mergeCachedAndUncachedSequences(query, sequencesByInterval);
            }

            private void addSequencesFromCache(ArrayList<Sequence<T>> listOfSequences) {
                if (strategy == null) {
                    return;
                }
                Function pullFromCacheFunction = strategy.pullFromCache();
                final TypeReference cacheObjectClazz = strategy.getCacheObjectClazz();
                for (Pair cachedResultPair : cachedResults) {
                    final byte[] cachedResult = (byte[])cachedResultPair.rhs;
                    BaseSequence cachedSequence = new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object, Iterator<Object>>(){

                        public Iterator<Object> make() {
                            try {
                                if (cachedResult.length == 0) {
                                    return Iterators.emptyIterator();
                                }
                                return CachingClusteredClient.this.objectMapper.readValues(CachingClusteredClient.this.objectMapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }

                        public void cleanup(Iterator<Object> iterFromMake) {
                        }
                    });
                    listOfSequences.add(Sequences.map((Sequence)cachedSequence, (Function)pullFromCacheFunction));
                }
            }

            private void addSequencesFromServer(ArrayList<Sequence<T>> listOfSequences) {
                listOfSequences.ensureCapacity(listOfSequences.size() + serverSegments.size());
                final Query rewrittenQuery = query.withOverriddenContext((Map)contextBuilder.build());
                for (Map.Entry entry : serverSegments.entrySet()) {
                    Sequence resultSeqToAdd;
                    DruidServer server = (DruidServer)entry.getKey();
                    List descriptors = (List)entry.getValue();
                    QueryRunner clientQueryable = CachingClusteredClient.this.serverView.getQueryRunner(server);
                    if (clientQueryable == null) {
                        log.error("WTF!? server[%s] doesn't have a client Queryable?", new Object[]{server});
                        continue;
                    }
                    MultipleSpecificSegmentSpec segmentSpec = new MultipleSpecificSegmentSpec(descriptors);
                    if (!server.isAssignable() || !populateCache || isBySegment) {
                        if (!isBySegment) {
                            resultSeqToAdd = clientQueryable.run(query.withQuerySegmentSpec((QuerySegmentSpec)segmentSpec), responseContext);
                        } else {
                            Query bySegmentQuery = query;
                            Sequence resultSequence = clientQueryable.run(bySegmentQuery.withQuerySegmentSpec((QuerySegmentSpec)segmentSpec), responseContext);
                            resultSeqToAdd = Sequences.map((Sequence)resultSequence, (Function)new Function<Result<BySegmentResultValueClass<T>>, Result<BySegmentResultValueClass<T>>>(){

                                public Result<BySegmentResultValueClass<T>> apply(Result<BySegmentResultValueClass<T>> input) {
                                    BySegmentResultValueClass bySegmentValue = (BySegmentResultValueClass)input.getValue();
                                    return new Result(input.getTimestamp(), (Object)new BySegmentResultValueClass(Lists.transform((List)bySegmentValue.getResults(), (Function)toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing())), bySegmentValue.getSegmentId(), bySegmentValue.getInterval()));
                                }
                            });
                        }
                    } else {
                        Sequence runningSequence = clientQueryable.run(rewrittenQuery.withQuerySegmentSpec((QuerySegmentSpec)segmentSpec), responseContext);
                        resultSeqToAdd = new MergeSequence(query.getResultOrdering(), Sequences.map((Sequence)runningSequence, (Function)new Function<Result<BySegmentResultValueClass<T>>, Sequence<T>>(){
                            private final Function<T, Object> cacheFn;
                            {
                                this.cacheFn = strategy.prepareForCache();
                            }

                            public Sequence<T> apply(Result<BySegmentResultValueClass<T>> input) {
                                BySegmentResultValueClass value = (BySegmentResultValueClass)input.getValue();
                                final CachePopulator cachePopulator = (CachePopulator)cachePopulatorMap.get(String.format("%s_%s", value.getSegmentId(), value.getInterval()));
                                final ConcurrentLinkedQueue cacheFutures = new ConcurrentLinkedQueue();
                                return Sequences.withEffect((Sequence)Sequences.map((Sequence)Sequences.map((Sequence)Sequences.simple((Iterable)value.getResults()), (Function)new Function<T, T>(){

                                    public T apply(final T input) {
                                        if (cachePopulator != null) {
                                            cacheFutures.add(CachingClusteredClient.this.backgroundExecutorService.submit((Callable)new Callable<Object>(){

                                                @Override
                                                public Object call() {
                                                    return cacheFn.apply(input);
                                                }
                                            }));
                                        }
                                        return input;
                                    }
                                }), (Function)toolChest.makePreComputeManipulatorFn(rewrittenQuery, MetricManipulatorFns.deserializing())), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (cachePopulator != null) {
                                            Futures.addCallback((ListenableFuture)Futures.allAsList((Iterable)cacheFutures), (FutureCallback)new FutureCallback<List<Object>>(){

                                                public void onSuccess(List<Object> cacheData) {
                                                    cachePopulator.populate(cacheData);
                                                    cacheFutures.clear();
                                                }

                                                public void onFailure(Throwable throwable) {
                                                    log.error(throwable, "Background caching failed", new Object[0]);
                                                }
                                            }, (Executor)CachingClusteredClient.this.backgroundExecutorService);
                                        }
                                    }
                                }, (Executor)MoreExecutors.sameThreadExecutor());
                            }
                        }));
                    }
                    listOfSequences.add(resultSeqToAdd);
                }
            }
        });
    }

    protected Sequence<T> mergeCachedAndUncachedSequences(Query<T> query, List<Sequence<T>> sequencesByInterval) {
        if (sequencesByInterval.isEmpty()) {
            return Sequences.empty();
        }
        return new MergeSequence(query.getResultOrdering(), Sequences.simple(sequencesByInterval));
    }

    private static class CachePopulator {
        private final Cache cache;
        private final ObjectMapper mapper;
        private final Cache.NamedKey key;

        public CachePopulator(Cache cache, ObjectMapper mapper, Cache.NamedKey key) {
            this.cache = cache;
            this.mapper = mapper;
            this.key = key;
        }

        public void populate(Iterable<Object> results) {
            CacheUtil.populate(this.cache, this.mapper, this.key, results);
        }
    }
}

