/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.conversions.storage$;
import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.http.param.CompressionLevel;
import com.twitter.finagle.http.param.CompressionLevel$;
import com.twitter.finagle.http.param.Decompression;
import com.twitter.finagle.http.param.Decompression$;
import com.twitter.finagle.http.param.MaxChunkSize;
import com.twitter.finagle.http.param.MaxChunkSize$;
import com.twitter.finagle.http.param.MaxHeaderSize;
import com.twitter.finagle.http.param.MaxHeaderSize$;
import com.twitter.finagle.http.param.MaxInitialLineSize;
import com.twitter.finagle.http.param.MaxInitialLineSize$;
import com.twitter.finagle.http.param.MaxRequestSize;
import com.twitter.finagle.http.param.MaxRequestSize$;
import com.twitter.finagle.http.param.MaxResponseSize;
import com.twitter.finagle.http.param.MaxResponseSize$;
import com.twitter.finagle.http.param.Streaming;
import com.twitter.finagle.http.param.Streaming$;
import com.twitter.finagle.netty4.Netty4Listener;
import com.twitter.finagle.netty4.Netty4Listener$;
import com.twitter.finagle.netty4.Netty4Transporter$;
import com.twitter.finagle.netty4.channel.DirectToHeapInboundHandler$;
import com.twitter.finagle.netty4.http.TextualContentCompressor;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler$;
import com.twitter.finagle.netty4.http.handler.ClientExceptionMapper$;
import com.twitter.finagle.netty4.http.handler.FixedLengthMessageAggregator;
import com.twitter.finagle.netty4.http.handler.PayloadSizeHandler;
import com.twitter.finagle.netty4.http.handler.RespondToExpectContinue$;
import com.twitter.finagle.netty4.package$;
import com.twitter.finagle.param.Logger$;
import com.twitter.finagle.server.Listener;
import com.twitter.util.StorageUnit;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import java.net.SocketAddress;
import java.util.logging.Logger;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class exp$ {
    public static final exp$ MODULE$;
    private final String HttpCodecName;
    private final Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object>>> Netty4HttpTransporter;
    private final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit;
    private final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit;
    private final Function1<Stack.Params, Listener<Object, Object>> Netty4HttpListener;

    static {
        new exp$();
    }

    public String HttpCodecName() {
        return this.HttpCodecName;
    }

    public Function1<ChannelPipeline, BoxedUnit> initClient(Stack.Params params) {
        StorageUnit maxResponseSize = ((MaxResponseSize)params.apply(MaxResponseSize$.MODULE$.maxResponseSizeParam())).size();
        boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
        boolean streaming = ((Streaming)params.apply(Streaming$.MODULE$.maxResponseSizeParam())).enabled();
        return new Serializable(maxResponseSize, decompressionEnabled, streaming){
            public static final long serialVersionUID = 0L;
            private final StorageUnit maxResponseSize$1;
            private final boolean decompressionEnabled$1;
            private final boolean streaming$1;

            public final void apply(ChannelPipeline pipeline) {
                Object object = this.decompressionEnabled$1 ? pipeline.addLast("httpDecompressor", (ChannelHandler)new HttpContentDecompressor()) : BoxedUnit.UNIT;
                ChannelPipeline channelPipeline = this.streaming$1 ? pipeline.addLast("fixedLenAggregator", (ChannelHandler)new FixedLengthMessageAggregator(storage$.MODULE$.intToStorageUnitableWholeNumber(8).kilobytes())) : pipeline.addLast("httpDechunker", (ChannelHandler)new HttpObjectAggregator((int)this.maxResponseSize$1.inBytes()));
                pipeline.addLast("clientExceptionMapper", (ChannelHandler)ClientExceptionMapper$.MODULE$);
            }
            {
                this.maxResponseSize$1 = maxResponseSize$1;
                this.decompressionEnabled$1 = decompressionEnabled$1;
                this.streaming$1 = streaming$1;
            }
        };
    }

    public Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object>>> Netty4HttpTransporter() {
        return this.Netty4HttpTransporter;
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit() {
        return this.ClientPipelineInit;
    }

    public Function1<ChannelPipeline, BoxedUnit> initServer(Stack.Params params) {
        StorageUnit maxRequestSize = ((MaxRequestSize)params.apply(MaxRequestSize$.MODULE$.maxRequestSizeParam())).size();
        boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
        int compressionLevel = ((CompressionLevel)params.apply(CompressionLevel$.MODULE$.compressionLevelParam())).level();
        boolean streaming = ((Streaming)params.apply(Streaming$.MODULE$.maxResponseSizeParam())).enabled();
        Logger log = ((com.twitter.finagle.param.Logger)params.apply(Logger$.MODULE$.param())).log();
        return new Serializable(maxRequestSize, decompressionEnabled, compressionLevel, streaming, log){
            public static final long serialVersionUID = 0L;
            private final StorageUnit maxRequestSize$1;
            private final boolean decompressionEnabled$2;
            private final int compressionLevel$1;
            private final boolean streaming$2;
            private final Logger log$1;

            public final void apply(ChannelPipeline pipeline) {
                ChannelPipeline channelPipeline;
                int n = this.compressionLevel$1;
                Object object = n > 0 ? pipeline.addLast("httpCompressor", (ChannelHandler)new HttpContentCompressor(n)) : (-1 == n ? pipeline.addLast("httpCompressor", (ChannelHandler)new TextualContentCompressor()) : BoxedUnit.UNIT);
                Object object2 = this.decompressionEnabled$2 ? pipeline.addLast("httpDecompressor", (ChannelHandler)new HttpContentDecompressor()) : BoxedUnit.UNIT;
                if (this.streaming$2) {
                    pipeline.addLast("payloadSizeHandler", (ChannelHandler)new PayloadSizeHandler(this.maxRequestSize$1, (Option<Logger>)new Some((Object)this.log$1)));
                    pipeline.addLast("expectContinue", (ChannelHandler)RespondToExpectContinue$.MODULE$);
                    channelPipeline = pipeline.addLast("fixedLenAggregator", (ChannelHandler)new FixedLengthMessageAggregator(this.maxRequestSize$1));
                } else {
                    channelPipeline = pipeline.addLast("httpDechunker", (ChannelHandler)new HttpObjectAggregator((int)this.maxRequestSize$1.inBytes()));
                }
                pipeline.addLast("badRequestHandler", (ChannelHandler)BadRequestHandler$.MODULE$);
            }
            {
                this.maxRequestSize$1 = maxRequestSize$1;
                this.decompressionEnabled$2 = decompressionEnabled$2;
                this.compressionLevel$1 = compressionLevel$1;
                this.streaming$2 = streaming$2;
                this.log$1 = log$1;
            }
        };
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit() {
        return this.ServerPipelineInit;
    }

    public Function1<Stack.Params, Listener<Object, Object>> Netty4HttpListener() {
        return this.Netty4HttpListener;
    }

    private exp$() {
        MODULE$ = this;
        this.HttpCodecName = "httpCodec";
        this.Netty4HttpTransporter = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<SocketAddress, Transporter<Object, Object>> apply(Stack.Params params) {
                return new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final Stack.Params params$1;

                    public final Transporter<Object, Object> apply(SocketAddress addr) {
                        return Netty4Transporter$.MODULE$.raw((Function1)exp$.MODULE$.ClientPipelineInit().apply((Object)this.params$1), addr, this.params$1, Netty4Transporter$.MODULE$.raw$default$4(), ManifestFactory$.MODULE$.Any());
                    }
                    {
                        this.params$1 = params$1;
                    }
                };
            }
        };
        this.ClientPipelineInit = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<ChannelPipeline, BoxedUnit> apply(Stack.Params params) {
                return new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final Stack.Params params$2;

                    public final void apply(ChannelPipeline pipeline) {
                        StorageUnit maxChunkSize = ((MaxChunkSize)this.params$2.apply(MaxChunkSize$.MODULE$.maxChunkSizeParam())).size();
                        StorageUnit maxHeaderSize = ((MaxHeaderSize)this.params$2.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
                        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)this.params$2.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
                        pipeline.addLast(package$.MODULE$.DirectToHeapInboundHandlerName(), (ChannelHandler)DirectToHeapInboundHandler$.MODULE$);
                        HttpClientCodec codec = new HttpClientCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), (int)maxChunkSize.inBytes());
                        pipeline.addLast(exp$.MODULE$.HttpCodecName(), (ChannelHandler)codec);
                        exp$.MODULE$.initClient(this.params$2).apply((Object)pipeline);
                    }
                    {
                        this.params$2 = params$2;
                    }
                };
            }
        };
        this.ServerPipelineInit = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<ChannelPipeline, BoxedUnit> apply(Stack.Params params) {
                return new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final Stack.Params params$3;

                    public final void apply(ChannelPipeline pipeline) {
                        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)this.params$3.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
                        StorageUnit maxHeaderSize = ((MaxHeaderSize)this.params$3.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
                        StorageUnit maxRequestSize = ((MaxRequestSize)this.params$3.apply(MaxRequestSize$.MODULE$.maxRequestSizeParam())).size();
                        HttpServerCodec codec = new HttpServerCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), (int)maxRequestSize.inBytes());
                        pipeline.addLast(package$.MODULE$.DirectToHeapInboundHandlerName(), (ChannelHandler)DirectToHeapInboundHandler$.MODULE$);
                        pipeline.addLast(exp$.MODULE$.HttpCodecName(), (ChannelHandler)codec);
                        exp$.MODULE$.initServer(this.params$3).apply((Object)pipeline);
                    }
                    {
                        this.params$3 = params$3;
                    }
                };
            }
        };
        this.Netty4HttpListener = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Netty4Listener<Object, Object> apply(Stack.Params params) {
                Stack.Params x$1 = params;
                Function1 x$2 = (Function1)exp$.MODULE$.ServerPipelineInit().apply((Object)params);
                Function1 x$3 = Netty4Listener$.MODULE$.apply$default$3();
                Function1 x$4 = Netty4Listener$.MODULE$.apply$default$4();
                return new Netty4Listener(x$2, x$1, x$3, x$4, ManifestFactory$.MODULE$.Any(), ManifestFactory$.MODULE$.Any());
            }
        };
    }
}

