/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.http.codec.ChannelBufferUsageTracker;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3Q!\u0001\u0002\u0001\u00051\u0011aBQ=uK\n+h-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005!\u0001\u000e\u001e;q\u0015\t)a!\u0001\u0004oKR$\u0018\u0010\u000e\u0006\u0003\u000f!\tqAZ5oC\u001edWM\u0003\u0002\n\u0015\u00059Ao^5ui\u0016\u0014(\"A\u0006\u0002\u0007\r|Wn\u0005\u0002\u0001\u001bA\u0011a\"F\u0007\u0002\u001f)\u0011\u0001#E\u0001\bG\"\fgN\\3m\u0015\t\u00112#A\u0003oKR$\u0018PC\u0001\u0015\u0003\tIw.\u0003\u0002\u0017\u001f\t!2\t[1o]\u0016dG)\u001e9mKbD\u0015M\u001c3mKJD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\rkN\fw-\u001a+sC\u000e\\WM]\u0002\u0001!\tYr$D\u0001\u001d\u0015\tib$A\u0003d_\u0012,7M\u0003\u0002\u0004\r%\u0011\u0001\u0005\b\u0002\u001a\u0007\"\fgN\\3m\u0005V4g-\u001a:Vg\u0006<W\r\u0016:bG.,'\u000fC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0019\u0002\"!\n\u0001\u000e\u0003\tAQ\u0001G\u0011A\u0002iAa\u0001\u000b\u0001!B\u0013I\u0013a\u00032vM\u001a,'/V:bO\u0016\u0004\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012A\u0001T8oO\")\u0001\u0007\u0001C!c\u0005)qO]5uKR!!'\u000e\u001e@!\tQ3'\u0003\u00025W\t!QK\\5u\u0011\u00151t\u00061\u00018\u0003\r\u0019G\u000f\u001f\t\u0003\u001daJ!!O\b\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")1h\fa\u0001y\u0005\u0019Qn]4\u0011\u0005)j\u0014B\u0001 ,\u0005\r\te.\u001f\u0005\u0006\u0001>\u0002\r!Q\u0001\baJ|W.[:f!\tq!)\u0003\u0002D\u001f\tq1\t[1o]\u0016d\u0007K]8nSN,\u0007\"B#\u0001\t\u00032\u0015aC2iC:tW\r\u001c*fC\u0012$2AM$I\u0011\u00151D\t1\u00018\u0011\u0015YD\t1\u0001=\u0011\u0015Q\u0005\u0001\"\u0011L\u0003\u0015\u0019Gn\\:f)\r\u0011D*\u0014\u0005\u0006m%\u0003\ra\u000e\u0005\u0006\u001d&\u0003\r!Q\u0001\u0007MV$XO]3\t\rA\u0003\u0001\u0015\"\u0003R\u0003MIgn\u0019:fCN,')\u001e4gKJ,6/Y4f)\t\u0011$\u000bC\u0003T\u001f\u0002\u0007\u0011&\u0001\u0003tSj,\u0007BB+\u0001A\u0013%a+\u0001\tdY\u0016\f'OQ;gM\u0016\u0014Xk]1hKR\t!\u0007")
public class ByteBufManager
extends ChannelDuplexHandler {
    private final ChannelBufferUsageTracker usageTracker;
    private long bufferUsage;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.clearBufferUsage();
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            this.increaseBufferUsage(byteBuf.capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise future) {
        this.clearBufferUsage();
        super.close(ctx, future);
    }

    private void increaseBufferUsage(long size) {
        this.usageTracker.increase(size);
        this.bufferUsage += size;
    }

    private void clearBufferUsage() {
        this.usageTracker.decrease(this.bufferUsage);
        this.bufferUsage = 0L;
    }

    public ByteBufManager(ChannelBufferUsageTracker usageTracker) {
        this.usageTracker = usageTracker;
        this.bufferUsage = 0L;
    }
}

