/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.metamx.common.collect.Utils;
import com.metamx.common.parsers.ParseException;
import com.metamx.common.parsers.Parser;
import com.metamx.common.parsers.ParserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DelimitedParser
implements Parser<String, Object> {
    private static final String DEFAULT_DELIMITER = "\t";
    private final String delimiter;
    private final String listDelimiter;
    private final Splitter splitter;
    private final Splitter listSplitter;
    private final Function<String, Object> valueFunction;
    private ArrayList<String> fieldNames = null;

    public DelimitedParser(Optional<String> delimiter, Optional<String> listDelimiter) {
        this.delimiter = delimiter.isPresent() ? (String)delimiter.get() : DEFAULT_DELIMITER;
        this.listDelimiter = listDelimiter.isPresent() ? (String)listDelimiter.get() : "\u0001";
        Preconditions.checkState((!this.delimiter.equals(this.listDelimiter) ? 1 : 0) != 0, (String)"Cannot have same delimiter and list delimiter of [%s]", (Object[])new Object[]{this.delimiter});
        this.splitter = Splitter.on((String)this.delimiter);
        this.listSplitter = Splitter.on((String)this.listDelimiter);
        this.valueFunction = new Function<String, Object>(){

            public Object apply(String input) {
                if (input.contains(DelimitedParser.this.listDelimiter)) {
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)DelimitedParser.this.listSplitter.split((CharSequence)input), ParserUtils.nullEmptyStringFunction));
                }
                return ParserUtils.nullEmptyStringFunction.apply((Object)input);
            }
        };
    }

    public DelimitedParser(Optional<String> delimiter, Optional<String> listDelimiter, Iterable<String> fieldNames) {
        this(delimiter, listDelimiter);
        this.setFieldNames(fieldNames);
    }

    public DelimitedParser(Optional<String> delimiter, Optional<String> listDelimiter, String header) {
        this(delimiter, listDelimiter);
        this.setFieldNames(header);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    public void setFieldNames(String header) {
        try {
            this.setFieldNames(this.splitter.split((CharSequence)header));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse header [%s]", header);
        }
    }

    @Override
    public Map<String, Object> parse(String input) {
        try {
            Iterable values = this.splitter.split((CharSequence)input);
            if (this.fieldNames == null) {
                this.setFieldNames(ParserUtils.generateFieldNames(Iterators.size(values.iterator())));
            }
            return Utils.zipMapPartial(this.fieldNames, Iterables.transform((Iterable)values, this.valueFunction));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }
}

