/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.io.smoosh;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.primitives.Ints;
import com.metamx.common.FileUtils;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.MappedByteBufferHandler;
import com.metamx.common.io.smoosh.Metadata;
import com.metamx.common.io.smoosh.SmooshedWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileSmoosher
implements Closeable {
    private static final String FILE_EXTENSION = "smoosh";
    private static final Joiner joiner = Joiner.on((String)",");
    private final File baseDir;
    private final int maxChunkSize;
    private final List<File> outFiles = Lists.newArrayList();
    private final Map<String, Metadata> internalFiles = Maps.newTreeMap();
    private Outer currOut = null;

    public FileSmoosher(File baseDir) {
        this(baseDir, Integer.MAX_VALUE);
    }

    public FileSmoosher(File baseDir, int maxChunkSize) {
        this.baseDir = baseDir;
        this.maxChunkSize = maxChunkSize;
        Preconditions.checkArgument((maxChunkSize > 0 ? 1 : 0) != 0, (Object)"maxChunkSize must be a positive value.");
    }

    public Set<String> getInternalFilenames() {
        return this.internalFiles.keySet();
    }

    public void add(File fileToAdd) throws IOException {
        this.add(fileToAdd.getName(), fileToAdd);
    }

    public void add(String name, File fileToAdd) throws IOException {
        try (MappedByteBufferHandler fileMappingHandler = FileUtils.map(fileToAdd);){
            this.add(name, fileMappingHandler.get());
        }
    }

    public void add(String name, ByteBuffer bufferToAdd) throws IOException {
        this.add(name, Arrays.asList(bufferToAdd));
    }

    public void add(String name, List<ByteBuffer> bufferToAdd) throws IOException {
        if (name.contains(",")) {
            throw new IAE("Cannot have a comma in the name of a file, got[%s].", name);
        }
        if (this.internalFiles.get(name) != null) {
            throw new IAE("Cannot add files of the same name, already have [%s]", name);
        }
        long size = 0L;
        for (ByteBuffer buffer : bufferToAdd) {
            size += (long)buffer.remaining();
        }
        try (SmooshedWriter out = this.addWithSmooshedWriter(name, size);){
            for (ByteBuffer buffer : bufferToAdd) {
                out.write(buffer);
            }
        }
    }

    public SmooshedWriter addWithSmooshedWriter(final String name, final long size) throws IOException {
        if (size > (long)this.maxChunkSize) {
            throw new IAE("Asked to add buffers[%,d] larger than configured max[%,d]", size, this.maxChunkSize);
        }
        if (this.currOut == null) {
            this.currOut = this.getNewCurrOut();
        }
        if ((long)this.currOut.bytesLeft() < size) {
            this.currOut.close();
            this.currOut = this.getNewCurrOut();
        }
        final int startOffset = this.currOut.getCurrOffset();
        return new SmooshedWriter(){
            private boolean open = true;
            private long bytesWritten = 0L;

            @Override
            public int write(InputStream in) throws IOException {
                return this.verifySize(FileSmoosher.this.currOut.write(in));
            }

            @Override
            public int write(ByteBuffer in) throws IOException {
                return this.verifySize(FileSmoosher.this.currOut.write(in));
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return this.verifySize(FileSmoosher.this.currOut.write(srcs, offset, length));
            }

            @Override
            public long write(ByteBuffer[] srcs) throws IOException {
                return this.verifySize(FileSmoosher.this.currOut.write(srcs));
            }

            private int verifySize(long bytesWrittenInChunk) throws IOException {
                this.bytesWritten += bytesWrittenInChunk;
                if (this.bytesWritten != (long)(FileSmoosher.this.currOut.getCurrOffset() - startOffset)) {
                    throw new ISE("WTF? Perhaps there is some concurrent modification going on?", new Object[0]);
                }
                if (this.bytesWritten > size) {
                    throw new ISE("Wrote[%,d] bytes for something of size[%,d].  Liar!!!", this.bytesWritten, size);
                }
                return Ints.checkedCast((long)bytesWrittenInChunk);
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public void close() throws IOException {
                this.open = false;
                FileSmoosher.this.internalFiles.put(name, new Metadata(FileSmoosher.this.currOut.getFileNum(), startOffset, FileSmoosher.this.currOut.getCurrOffset()));
                if (this.bytesWritten != (long)(FileSmoosher.this.currOut.getCurrOffset() - startOffset)) {
                    throw new ISE("WTF? Perhaps there is some concurrent modification going on?", new Object[0]);
                }
                if (this.bytesWritten != size) {
                    throw new IOException(String.format("Expected [%,d] bytes, only saw [%,d], potential corruption?", size, this.bytesWritten));
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.currOut != null) {
            this.currOut.close();
        }
        File metaFile = FileSmoosher.metaFile(this.baseDir);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(metaFile), Charsets.UTF_8));){
            out.write(String.format("v1,%d,%d", this.maxChunkSize, this.outFiles.size()));
            out.write("\n");
            for (Map.Entry<String, Metadata> entry : this.internalFiles.entrySet()) {
                Metadata metadata = entry.getValue();
                out.write(joiner.join((Object)entry.getKey(), (Object)metadata.getFileNum(), new Object[]{metadata.getStartOffset(), metadata.getEndOffset()}));
                out.write("\n");
            }
        }
    }

    private Outer getNewCurrOut() throws FileNotFoundException {
        int fileNum = this.outFiles.size();
        File outFile = FileSmoosher.makeChunkFile(this.baseDir, fileNum);
        this.outFiles.add(outFile);
        return new Outer(fileNum, new FileOutputStream(outFile), this.maxChunkSize);
    }

    static File metaFile(File baseDir) {
        return new File(baseDir, String.format("meta.%s", FILE_EXTENSION));
    }

    static File makeChunkFile(File baseDir, int i) {
        return new File(baseDir, String.format("%05d.%s", i, FILE_EXTENSION));
    }

    public static class Outer
    implements SmooshedWriter {
        private final int fileNum;
        private final int maxLength;
        private final GatheringByteChannel channel;
        private final Closer closer = Closer.create();
        private int currOffset = 0;

        Outer(int fileNum, FileOutputStream output, int maxLength) {
            this.fileNum = fileNum;
            this.channel = output.getChannel();
            this.maxLength = maxLength;
            this.closer.register((Closeable)output);
            this.closer.register((Closeable)this.channel);
        }

        public int getFileNum() {
            return this.fileNum;
        }

        public int getCurrOffset() {
            return this.currOffset;
        }

        public int bytesLeft() {
            return this.maxLength - this.currOffset;
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException {
            return this.addToOffset(this.channel.write(buffer));
        }

        @Override
        public int write(InputStream in) throws IOException {
            return this.addToOffset(ByteStreams.copy((ReadableByteChannel)Channels.newChannel(in), (WritableByteChannel)this.channel));
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.addToOffset(this.channel.write(srcs, offset, length));
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.addToOffset(this.channel.write(srcs));
        }

        public int addToOffset(long numBytesWritten) {
            if (numBytesWritten > (long)this.bytesLeft()) {
                throw new ISE("Wrote more bytes[%,d] than available[%,d]. Don't do that.", numBytesWritten, this.bytesLeft());
            }
            this.currOffset = (int)((long)this.currOffset + numBytesWritten);
            return Ints.checkedCast((long)numBytesWritten);
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
        }
    }
}

