/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.service.model.S3Bucket;

public class RequesterPaysDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 2406896456675486928L;
    private boolean okClicked = false;
    private JTextField bucketNameTextField = null;
    private JCheckBox requesterPaysCheckBox = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);

    public RequesterPaysDialog(S3Bucket bucket, Frame ownerFrame, HyperlinkActivatedListener hyperlinkListener) {
        super(ownerFrame, "Requester Pays", true);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("Update Status");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        JHtmlLabel bucketNameLabel = new JHtmlLabel("<html><b>Bucket name</b></html>", hyperlinkListener);
        bucketNameLabel.setHorizontalAlignment(0);
        this.bucketNameTextField = new JTextField(bucket.getName());
        this.bucketNameTextField.setEditable(false);
        JHtmlLabel requesterPaysLabel = new JHtmlLabel("<html><b>Requester Pays?</b></html>", hyperlinkListener);
        this.requesterPaysCheckBox = new JCheckBox();
        this.requesterPaysCheckBox.setSelected(bucket.isRequesterPays());
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -6225706489569112809L;

            public void actionPerformed(ActionEvent actionEvent) {
                RequesterPaysDialog.this.setVisible(false);
                RequesterPaysDialog.this.okClicked = false;
            }
        });
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        buttonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        panel.add((Component)bucketNameLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)this.bucketNameTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        panel.add((Component)requesterPaysLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)this.requesterPaysCheckBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)buttonsPanel, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(ownerFrame);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.okButton)) {
            this.setVisible(false);
            this.okClicked = true;
        } else if (event.getSource().equals(this.cancelButton)) {
            this.setVisible(false);
            this.okClicked = false;
        }
    }

    public boolean getOkClicked() {
        return this.okClicked;
    }

    public boolean isRequesterPaysSelected() {
        return this.requesterPaysCheckBox.isSelected();
    }
}

