/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.util.Base64Long$;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Base64Long$ {
    public static final Base64Long$ MODULE$;
    private final int DigitWidth;
    public final int com$twitter$util$Base64Long$$AlphabetSize;
    private final int DigitMask;
    private final int StartingBitPosition;
    private final PartialFunction<Object, Object> StandardBase64Alphabet;
    private final ThreadLocal<StringBuilder> threadLocalBuilder;
    private final PartialFunction<Object, Object> StandardBase64AlphabetInverted;

    static {
        new Base64Long$();
    }

    public PartialFunction<Object, Object> alphabet(Iterable<Object> chars) {
        Predef$.MODULE$.require(chars.size() == this.com$twitter$util$Base64Long$$AlphabetSize, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"base-64 alphabet must have exactly ", " characters"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Base64Long$.MODULE$.com$twitter$util$Base64Long$$AlphabetSize)}));
            }
        });
        char[] result2 = (char[])chars.toArray(ClassTag$.MODULE$.Char());
        Predef$.MODULE$.require(Arrays.equals((char[])Predef$.MODULE$.charArrayOps(result2).distinct(), result2), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"base-64 alphabet must not repeat characters"})).s((Seq)Nil$.MODULE$);
            }
        });
        return Predef$.MODULE$.wrapCharArray(result2);
    }

    public PartialFunction<Object, Object> StandardBase64Alphabet() {
        return this.StandardBase64Alphabet;
    }

    public String toBase64(long l) {
        StringBuilder b = this.threadLocalBuilder.get();
        b.clear();
        this.toBase64(b, l, this.toBase64$default$3());
        return b.toString();
    }

    public void toBase64(StringBuilder builder, long l, Function1<Object, Object> alphabet2) {
        if (l == 0L) {
            builder.append(BoxesRunTime.unboxToChar((Object)alphabet2.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        } else {
            int bitPosition = this.StartingBitPosition;
            while (l >>> bitPosition == 0L) {
                bitPosition -= this.DigitWidth;
            }
            while (bitPosition >= 0) {
                long shifted = l >>> bitPosition;
                int digitValue = (int)(shifted & (long)this.DigitMask);
                builder.append(BoxesRunTime.unboxToChar((Object)alphabet2.apply((Object)BoxesRunTime.boxToInteger((int)digitValue))));
                bitPosition -= this.DigitWidth;
            }
        }
    }

    public Function1<Object, Object> toBase64$default$3() {
        return this.StandardBase64Alphabet();
    }

    public PartialFunction<Object, Object> invertAlphabet(Function1<Object, Object> forward) {
        IndexedSeq chars = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.com$twitter$util$Base64Long$$AlphabetSize).map(forward, IndexedSeq$.MODULE$.canBuildFrom());
        return chars.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 <= '\u00ff';
            }
        }) ? new PartialFunction<Object, Object>(forward, chars){
            private final char maxChar;
            public final byte[] com$twitter$util$Base64Long$$anon$$reverse;

            public <A1, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
                return PartialFunction.class.orElse((PartialFunction)this, that);
            }

            public <C> PartialFunction<Object, C> andThen(Function1<Object, C> k) {
                return PartialFunction.class.andThen((PartialFunction)this, k);
            }

            public Function1<Object, Option<Object>> lift() {
                return PartialFunction.class.lift((PartialFunction)this);
            }

            public Object applyOrElse(Object x, Function1 function1) {
                return PartialFunction.class.applyOrElse((PartialFunction)this, (Object)x, (Function1)function1);
            }

            public <U> Function1<Object, Object> runWith(Function1<Object, U> action) {
                return PartialFunction.class.runWith((PartialFunction)this, action);
            }

            public boolean apply$mcZD$sp(double v1) {
                return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.class.apply$mcZI$sp((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
            }

            public <A> Function1<A, Object> compose(Function1<A, Object> g) {
                return Function1.class.compose((Function1)this, g);
            }

            public String toString() {
                return Function1.class.toString((Function1)this);
            }

            public boolean isDefinedAt(char c) {
                return c <= this.maxChar && this.com$twitter$util$Base64Long$$anon$$reverse[c] != -1;
            }

            public int apply(char c) {
                return this.com$twitter$util$Base64Long$$anon$$reverse[c];
            }
            {
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
                this.maxChar = BoxesRunTime.unboxToChar((Object)chars$1.max((Ordering)Ordering.Char$.MODULE$));
                this.com$twitter$util$Base64Long$$anon$$reverse = (byte[])Array$.MODULE$.fill(this.maxChar + '\u0001', (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply() {
                        return this.apply$mcB$sp();
                    }

                    public byte apply$mcB$sp() {
                        return -1;
                    }
                }, ClassTag$.MODULE$.Byte());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Base64Long$.MODULE$.com$twitter$util$Base64Long$$AlphabetSize).foreach$mVc$sp((Function1)new Serializable(this, forward$1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final Function1 forward$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.com$twitter$util$Base64Long$$anon$$reverse[BoxesRunTime.unboxToChar((Object)this.forward$1.apply((Object)BoxesRunTime.boxToInteger((int)i)))] = (byte)i;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.forward$1 = forward$1;
                    }
                });
            }
        } : ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.com$twitter$util$Base64Long$$AlphabetSize).map((Function1)new Serializable(forward){
            public static final long serialVersionUID = 0L;
            private final Function1 forward$1;

            public final Tuple2<Object, Object> apply(int i) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.forward$1.apply((Object)BoxesRunTime.boxToInteger((int)i))), (Object)BoxesRunTime.boxToInteger((int)i));
            }
            {
                this.forward$1 = forward$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public long fromBase64(CharSequence chars, int start2, int end, PartialFunction<Object, Object> alphabet2) {
        long result2 = 0L;
        for (int i = start2; i < end; ++i) {
            char c = chars.charAt(i);
            if (alphabet2.isDefinedAt((Object)BoxesRunTime.boxToCharacter((char)c))) {
                long shifted = result2 * (long)this.com$twitter$util$Base64Long$$AlphabetSize;
                if (shifted >>> this.DigitWidth != result2) {
                    throw new ArithmeticException("long overflow");
                }
                result2 = shifted | (long)(BoxesRunTime.unboxToInt((Object)alphabet2.apply((Object)BoxesRunTime.boxToCharacter((char)c))) & this.DigitMask);
                continue;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid base 64 character at ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToCharacter((char)chars.charAt(i))})));
        }
        return result2;
    }

    public long fromBase64(CharSequence chars) {
        return this.fromBase64(chars, 0, chars.length(), this.StandardBase64AlphabetInverted);
    }

    public PartialFunction<Object, Object> fromBase64$default$4() {
        return this.StandardBase64AlphabetInverted;
    }

    private Base64Long$() {
        MODULE$ = this;
        this.DigitWidth = 6;
        this.com$twitter$util$Base64Long$$AlphabetSize = 1 << this.DigitWidth;
        this.DigitMask = this.com$twitter$util$Base64Long$$AlphabetSize - 1;
        this.StartingBitPosition = this.com$twitter$util$Base64Long$$AlphabetSize - this.com$twitter$util$Base64Long$$AlphabetSize % this.DigitWidth;
        this.StandardBase64Alphabet = this.alphabet((Iterable<Object>)Predef$.MODULE$.wrapString("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"));
        this.threadLocalBuilder = new ThreadLocal<StringBuilder>(){

            public StringBuilder initialValue() {
                return new StringBuilder();
            }
        };
        this.StandardBase64AlphabetInverted = this.invertAlphabet((Function1<Object, Object>)this.StandardBase64Alphabet());
    }
}

