/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.concurrent;

import com.twitter.concurrent.AsyncMeter$;
import com.twitter.concurrent.Period$;
import com.twitter.util.Closable;
import com.twitter.util.Closable$;
import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Timer;
import com.twitter.util.TokenBucket;
import com.twitter.util.TokenBucket$;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015t!B\u0001\u0003\u0011\u0003I\u0011AC!ts:\u001cW*\u001a;fe*\u00111\u0001B\u0001\u000bG>t7-\u001e:sK:$(BA\u0003\u0007\u0003\u001d!x/\u001b;uKJT\u0011aB\u0001\u0004G>l7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u000b\u0003NLhnY'fi\u0016\u00148CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\t1-\u0011\r\u0011\"\u0001\u00033\u0005yQ*\u001b8j[Vl\u0017J\u001c;feZ\fG.F\u0001\u001b!\tYb$D\u0001\u001d\u0015\tiB!\u0001\u0003vi&d\u0017BA\u0010\u001d\u0005!!UO]1uS>t\u0007BB\u0011\fA\u0003%!$\u0001\tNS:LW.^7J]R,'O^1mA!)1e\u0003C\u0001I\u0005I\u0001/\u001a:TK\u000e|g\u000e\u001a\u000b\u0006K\u0005\u001d\u0012\u0011\u0006\u000b\u0004M\u0005\u0015\u0002C\u0001\u0006(\r\u0011a!\u0001\u0001\u0015\u0014\u0005\u001dr\u0001\"\u0003\u0016(\u0005\u000b\u0007I\u0011\u0001\u0002,\u0003%\u0011WO]:u'&TX-F\u0001-!\tyQ&\u0003\u0002/!\t\u0019\u0011J\u001c;\t\u0011A:#\u0011!Q\u0001\n1\n!BY;sgR\u001c\u0016N_3!\u0011!\u0011tE!A!\u0002\u0013Q\u0012!\u00042veN$H)\u001e:bi&|g\u000e\u0003\u00055O\t\u0005\t\u0015!\u00036\u0003\u0005\t\bc\u0001\u001c<{5\tqG\u0003\u0002\u0004q)\u0011Q$\u000f\u0006\u0002u\u0005!!.\u0019<b\u0013\tatGA\u0007CY>\u001c7.\u001b8h#V,W/\u001a\t\u0005\u001fy\u0002E&\u0003\u0002@!\t1A+\u001e9mKJ\u00022aG!D\u0013\t\u0011EDA\u0004Qe>l\u0017n]3\u0011\u0005=!\u0015BA#\u0011\u0005\u0011)f.\u001b;\t\u0011\u001d;#\u0011!Q\u0001\f!\u000bQ\u0001^5nKJ\u0004\"aG%\n\u0005)c\"!\u0002+j[\u0016\u0014\b\"B\u000b(\t\u0013aE\u0003B'P!F#\"A\n(\t\u000b\u001d[\u00059\u0001%\t\u000b)Z\u0005\u0019\u0001\u0017\t\u000bIZ\u0005\u0019\u0001\u000e\t\u000bQZ\u0005\u0019A\u001b\t\rM;\u0003\u0015!\u0003U\u0003\u0019\u0001XM]5pIB\u0011!\"V\u0005\u0003-\n\u0011a\u0001U3sS>$\u0007B\u0002-(A\u0003%!$\u0001\u0005j]R,'O^1m\u0011\u0019Qv\u0005)A\u00057\u00061!-^2lKR\u0004\"a\u0007/\n\u0005uc\"a\u0003+pW\u0016t')^2lKRDaaX\u0014!B\u0013\u0001\u0017!\u0003:f[\u0006Lg\u000eZ3s!\ty\u0011-\u0003\u0002c!\t1Ai\\;cY\u0016Da\u0001Z\u0014!B\u0013)\u0017a\u0002:v]:Lgn\u001a\t\u0003\u001f\u0019L!a\u001a\t\u0003\u000f\t{w\u000e\\3b]\"\u00121-\u001b\t\u0003\u001f)L!a\u001b\t\u0003\u0011Y|G.\u0019;jY\u0016Da!\\\u0014!B\u0013q\u0017\u0001\u0002;bg.\u0004\"aG8\n\u0005Ad\"\u0001C\"m_N\f'\r\\3\t\rI<\u0003\u0015)\u0003t\u0003\u001d)G.\u00199tK\u0012\u0004\"\u0001^<\u000f\u0005m)\u0018B\u0001<\u001d\u0003%\u0019Fo\u001c9xCR\u001c\u0007.\u0003\u0002ys\n9Q\t\\1qg\u0016$\u0017B\u0001>\u001d\u0005%\u0019Fo\u001c9xCR\u001c\u0007\u000eC\u0003}O\u0011\u0005Q0A\u0003bo\u0006LG\u000fF\u0002\u007f\u0003\u0007\u00012aG@D\u0013\r\t\t\u0001\b\u0002\u0007\rV$XO]3\t\r\u0005\u00151\u00101\u0001-\u0003\u001d\u0001XM]7jiNDq!!\u0003(\t\u0003\tY!\u0001\u0006ok6<\u0016-\u001b;feN$\u0012\u0001\f\u0005\t\u0003\u001f9\u0003\u0015\"\u0003\u0002\u0012\u0005aQ\u000f\u001d3bi\u0016\fe\u000eZ$fiR\u0019Q-a\u0005\t\u000f\u0005U\u0011Q\u0002a\u0001Y\u00051Ao\\6f]ND\u0001\"!\u0007(A\u0013%\u00111B\u0001\u0014O\u0016$h*^7SK\u001a\u0014Xm\u001d5U_.,gn\u001d\u0005\t\u0003;9\u0003\u0015\"\u0003\u0002 \u0005\u0011\"/Z:uCJ$H+[7fe&3G)Z1e)\u0005\u0019\u0005\u0002CA\u0012O\u0001&i!a\b\u0002\u000b\u0005dGn\\<\t\u000b\u001d\u0013\u00039\u0001%\t\r\u0005\u0015!\u00051\u0001-\u0011\u0019\tYC\ta\u0001Y\u0005QQ.\u0019=XC&$XM]:\t\u000f\u0005=2\u0002\"\u0001\u00022\u0005\u0001\u0002/\u001a:TK\u000e|g\u000e\u001a'j[&$X\r\u001a\u000b\u0007\u0003g\t9$!\u000f\u0015\u0007\u0019\n)\u0004\u0003\u0004H\u0003[\u0001\u001d\u0001\u0013\u0005\b\u0003\u000b\ti\u00031\u0001-\u0011\u001d\tY#!\fA\u00021Bq!!\u0010\f\t\u0003\ty$\u0001\u0005oK^lU\r^3s)!\t\t%!\u0012\u0002H\u0005%Cc\u0001\u0014\u0002D!1q)a\u000fA\u0004!CaAKA\u001e\u0001\u0004a\u0003B\u0002\u001a\u0002<\u0001\u0007!\u0004C\u0004\u0002,\u0005m\u0002\u0019\u0001\u0017\t\u000f\u000553\u0002\"\u0001\u0002P\u0005\tb.Z<V]\n|WO\u001c3fI6+G/\u001a:\u0015\r\u0005E\u0013QKA,)\r1\u00131\u000b\u0005\u0007\u000f\u0006-\u00039\u0001%\t\r)\nY\u00051\u0001-\u0011\u0019\u0011\u00141\na\u00015!9\u00111L\u0006\u0005\u0002\u0005u\u0013AD3yiJ\fw+\u001b3f\u0003^\f\u0017\u000e\u001e\u000b\u0006}\u0006}\u0013\u0011\r\u0005\b\u0003\u000b\tI\u00061\u0001-\u0011\u001d\t\u0019'!\u0017A\u0002\u0019\nQ!\\3uKJ\u0004")
public class AsyncMeter {
    private final int burstSize;
    public final Duration com$twitter$concurrent$AsyncMeter$$burstDuration;
    public final BlockingQueue<Tuple2<Promise<BoxedUnit>, Object>> com$twitter$concurrent$AsyncMeter$$q;
    private final Timer timer;
    private final Duration period;
    private final Duration interval;
    private final TokenBucket bucket;
    private double remainder;
    private volatile boolean running;
    private Closable task;
    private Function0<Duration> elapsed;

    public static Future<BoxedUnit> extraWideAwait(int n, AsyncMeter asyncMeter) {
        return AsyncMeter$.MODULE$.extraWideAwait(n, asyncMeter);
    }

    public static AsyncMeter newUnboundedMeter(int n, Duration duration, Timer timer) {
        return AsyncMeter$.MODULE$.newUnboundedMeter(n, duration, timer);
    }

    public static AsyncMeter newMeter(int n, Duration duration, int n2, Timer timer) {
        return AsyncMeter$.MODULE$.newMeter(n, duration, n2, timer);
    }

    public static AsyncMeter perSecondLimited(int n, int n2, Timer timer) {
        return AsyncMeter$.MODULE$.perSecondLimited(n, n2, timer);
    }

    public static AsyncMeter perSecond(int n, int n2, Timer timer) {
        return AsyncMeter$.MODULE$.perSecond(n, n2, timer);
    }

    public int burstSize() {
        return this.burstSize;
    }

    public Future<BoxedUnit> await(int permits) {
        Future<BoxedUnit> future2;
        if (permits > this.burstSize()) {
            return Future$.MODULE$.exception(new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to await on ", " permits, but the maximum burst size was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)permits), BoxesRunTime.boxToInteger((int)this.burstSize())}))));
        }
        if (!this.running && this.updateAndGet(permits)) {
            return Future$.MODULE$.Done();
        }
        Promise<BoxedUnit> p = Promise$.MODULE$.apply();
        Tuple2 tup = new Tuple2(p, (Object)BoxesRunTime.boxToInteger((int)permits));
        if (this.com$twitter$concurrent$AsyncMeter$$q.offer((Tuple2<Promise<BoxedUnit>, Object>)tup)) {
            p.setInterruptHandler((PartialFunction<Throwable, BoxedUnit>)new Serializable(this, p, tup){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncMeter $outer;
                private final Promise p$1;
                private final Tuple2 tup$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    BoxedUnit boxedUnit;
                    Boolean bl;
                    Object object;
                    A1 A1 = x1;
                    if (A1 == null) {
                        object = function1.apply(x1);
                        return (B1)object;
                    }
                    A1 A12 = A1;
                    AsyncMeter asyncMeter = this.$outer;
                    synchronized (asyncMeter) {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$twitter$concurrent$AsyncMeter$$q.remove(this.tup$1));
                    }
                    boolean rem = BoxesRunTime.unboxToBoolean((Object)bl);
                    if (rem) {
                        CancellationException e = new CancellationException("Request for permits was cancelled.");
                        e.initCause(A12);
                        this.p$1.setException(e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.p$1 = p$1;
                    this.tup$1 = tup$1;
                }
            });
            this.restartTimerIfDead();
            future2 = p;
        } else {
            future2 = Future$.MODULE$.exception(new RejectedExecutionException("Tried to wait when there were already the maximum number of waiters."));
        }
        return future2;
    }

    public int numWaiters() {
        return this.com$twitter$concurrent$AsyncMeter$$q.size();
    }

    private boolean updateAndGet(int tokens) {
        this.bucket.put(this.getNumRefreshTokens());
        return this.bucket.tryGet(tokens);
    }

    private synchronized int getNumRefreshTokens() {
        double newTokens = Period$.MODULE$.numPeriods$extension(this.period, (Duration)this.elapsed.apply());
        this.elapsed = Stopwatch$.MODULE$.start();
        double num = newTokens + this.remainder;
        double floor = package$.MODULE$.floor(num);
        this.remainder = num - floor;
        return (int)floor;
    }

    private synchronized void restartTimerIfDead() {
        if (!this.running) {
            this.running = true;
            this.task = this.timer.schedule(this.interval, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncMeter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.com$twitter$concurrent$AsyncMeter$$allow();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void com$twitter$concurrent$AsyncMeter$$allow() {
        tokens = this.getNumRefreshTokens();
        if (tokens > this.burstSize()) {
            tokens -= this.burstSize();
            this.bucket.put(this.burstSize());
        } else {
            this.bucket.put(tokens);
            tokens = 0;
        }
        while (true) {
            var3_3 = this;
            synchronized (var3_3) {
                block10: {
                    block11: {
                        block9: {
                            var5_5 = (Tuple2)this.com$twitter$concurrent$AsyncMeter$$q.peek();
                            if (var5_5 != null) break block9;
                            this.running = false;
                            this.task.close();
                            var6_6 = None$.MODULE$;
                            break block10;
                        }
                        if (var5_5 == null) break block11;
                        p = (Promise)var5_5._1();
                        num = var5_5._2$mcI$sp();
                        if (num >= tokens) break block11;
                        tokens -= num;
                        this.com$twitter$concurrent$AsyncMeter$$q.poll();
                        var6_6 = new Some((Object)p);
                        break block10;
                    }
                    if (var5_5 == null) ** GOTO lbl-1000
                    p = (Promise)var5_5._1();
                    num = var5_5._2$mcI$sp();
                    if (this.bucket.tryGet(num - tokens)) {
                        tokens = 0;
                        this.com$twitter$concurrent$AsyncMeter$$q.poll();
                        var6_6 = new Some((Object)p);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var6_6 = None$.MODULE$;
                    }
                }
                var4_4 = var6_6;
            }
            var11_11 = control = (Option)var4_4;
            if (!(var11_11 instanceof Some)) break;
            var12_12 = (Some)var11_11;
            p = (Promise)var12_12.x();
            p.setValue(BoxedUnit.UNIT);
            var14_14 = BoxedUnit.UNIT;
        }
        if (None$.MODULE$.equals(var11_11)) {
            return;
        }
        throw new MatchError((Object)var11_11);
        {
            catch (Throwable v0) {
                throw v0;
            }
        }
    }

    public AsyncMeter(int burstSize, Duration burstDuration, BlockingQueue<Tuple2<Promise<BoxedUnit>, Object>> q, Timer timer) {
        this.burstSize = burstSize;
        this.com$twitter$concurrent$AsyncMeter$$burstDuration = burstDuration;
        this.com$twitter$concurrent$AsyncMeter$$q = q;
        this.timer = timer;
        Predef$.MODULE$.require(burstSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncMeter $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"burst size of ", ", which is <= 0 doesn't make sense"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.burstSize())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(burstDuration.$greater(Duration$.MODULE$.Zero()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncMeter $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"burst duration of ", ", which is <= 0 nanoseconds doesn't make sense"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$twitter$concurrent$AsyncMeter$$burstDuration}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.period = Period$.MODULE$.fromBurstiness(burstSize, burstDuration);
        this.interval = Period$.MODULE$.realInterval$extension(this.period);
        this.bucket = TokenBucket$.MODULE$.newBoundedBucket(burstSize);
        this.bucket.put(burstSize);
        this.remainder = 0.0;
        this.running = false;
        this.task = Closable$.MODULE$.nop();
        this.elapsed = Stopwatch$.MODULE$.start();
    }
}

