/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.filter.Filters;
import java.util.Set;

public class InFilter
implements Filter {
    private final String dimension;
    private final Set<String> values;
    private final ExtractionFn extractionFn;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;

    public InFilter(String dimension, Set<String> values, Supplier<DruidLongPredicate> longPredicateSupplier, ExtractionFn extractionFn) {
        this.dimension = dimension;
        this.values = values;
        this.extractionFn = extractionFn;
        this.longPredicateSupplier = longPredicateSupplier;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(final BitmapIndexSelector selector) {
        if (this.extractionFn == null) {
            return selector.getBitmapFactory().union(Iterables.transform(this.values, (Function)new Function<String, ImmutableBitmap>(){

                public ImmutableBitmap apply(String value) {
                    return selector.getBitmapIndex(InFilter.this.dimension, value);
                }
            }));
        }
        return Filters.matchPredicate(this.dimension, selector, this.getPredicateFactory().makeStringPredicate());
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.getPredicateFactory());
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                if (InFilter.this.extractionFn != null) {
                    return new Predicate<String>(){

                        public boolean apply(String input) {
                            return InFilter.this.values.contains(Strings.nullToEmpty((String)InFilter.this.extractionFn.apply(input)));
                        }
                    };
                }
                return new Predicate<String>(){

                    public boolean apply(String input) {
                        return InFilter.this.values.contains(Strings.nullToEmpty((String)input));
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                if (InFilter.this.extractionFn != null) {
                    return new DruidLongPredicate(){

                        @Override
                        public boolean applyLong(long input) {
                            return InFilter.this.values.contains(InFilter.this.extractionFn.apply(input));
                        }
                    };
                }
                return (DruidLongPredicate)InFilter.this.longPredicateSupplier.get();
            }
        };
    }
}

