/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.BiMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.metamx.common.IAE;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.VSizeLongSerde;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class TableLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final BiMap<Long, Integer> table;
    private final int bitsPerValue;
    private VSizeLongSerde.LongSerializer serializer;

    public TableLongEncodingWriter(BiMap<Long, Integer> table) {
        if (table.size() > 256) {
            throw new IAE("Invalid table size[%s]", new Object[]{table.size()});
        }
        this.table = table;
        this.bitsPerValue = VSizeLongSerde.getBitsForMax(table.size());
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setOutputStream(OutputStream output) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, output);
    }

    @Override
    public void write(long value) throws IOException {
        this.serializer.write(((Integer)this.table.get((Object)value)).intValue());
    }

    @Override
    public void flush() throws IOException {
        if (this.serializer != null) {
            this.serializer.close();
        }
    }

    @Override
    public void putMeta(OutputStream metaOut, CompressedObjectStrategy.CompressionStrategy strategy) throws IOException {
        metaOut.write(CompressionFactory.setEncodingFlag(strategy.getId()));
        metaOut.write(CompressionFactory.LongEncodingFormat.TABLE.getId());
        metaOut.write(1);
        metaOut.write(Ints.toByteArray((int)this.table.size()));
        BiMap inverse = this.table.inverse();
        for (int i = 0; i < this.table.size(); ++i) {
            metaOut.write(Longs.toByteArray((long)((Long)inverse.get((Object)i))));
        }
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return VSizeLongSerde.getNumValuesPerBlock(this.bitsPerValue, bytesPerBlock);
    }

    @Override
    public int getNumBytes(int values) {
        return VSizeLongSerde.getSerializedSize(this.bitsPerValue, values);
    }
}

